/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.temp;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TempFileSystem
extends LocalFileSystemBase {
    private final FSItem myRoot = new FSDir(null, "/");

    public static TempFileSystem getInstance() {
        return (TempFileSystem)((Object)ApplicationManager.getApplication().getComponent(TempFileSystem.class));
    }

    @Override
    @NotNull
    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            TempFileSystem.$$$reportNull$$$0(0);
        }
        if ("/" == null) {
            TempFileSystem.$$$reportNull$$$0(1);
        }
        return "/";
    }

    @Nullable
    private FSItem convert(@NotNull VirtualFile file2) {
        VirtualFile parentFile;
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(2);
        }
        if ((parentFile = file2.getParent()) == null) {
            return this.myRoot;
        }
        FSItem parentItem = this.convert(parentFile);
        if (parentItem == null || !parentItem.isDirectory()) {
            return null;
        }
        return parentItem.findChild(file2.getName());
    }

    @NotNull
    private FSDir convertDirectory(@NotNull VirtualFile parent) {
        FSItem fsItem;
        if (parent == null) {
            TempFileSystem.$$$reportNull$$$0(3);
        }
        if ((fsItem = this.convert(parent)) == null) {
            FSRecords.invalidateCaches();
            throw new IllegalStateException("cannot find parent directory: " + parent.getPath());
        }
        assert (fsItem.isDirectory()) : "parent is not a directory: " + parent.getPath();
        FSDir fSDir = (FSDir)fsItem;
        if (fSDir == null) {
            TempFileSystem.$$$reportNull$$$0(4);
        }
        return fSDir;
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        FSDir fsDir;
        FSItem existingDir;
        if (parent == null) {
            TempFileSystem.$$$reportNull$$$0(5);
        }
        if (dir == null) {
            TempFileSystem.$$$reportNull$$$0(6);
        }
        if ((existingDir = (fsDir = this.convertDirectory(parent)).findChild(dir)) == null) {
            fsDir.addChild(new FSDir(fsDir, dir));
        } else if (!existingDir.isDirectory()) {
            throw new IOException("Directory already contains a file named " + dir);
        }
        FakeVirtualFile fakeVirtualFile = new FakeVirtualFile(parent, dir);
        if (fakeVirtualFile == null) {
            TempFileSystem.$$$reportNull$$$0(7);
        }
        return fakeVirtualFile;
    }

    @Override
    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file2) {
        if (parent == null) {
            TempFileSystem.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(9);
        }
        FSDir fsDir = this.convertDirectory(parent);
        assert (fsDir.findChild(file2) == null) : "File " + file2 + " already exists in " + parent.getPath();
        fsDir.addChild(new FSFile(fsDir, file2));
        FakeVirtualFile fakeVirtualFile = new FakeVirtualFile(parent, file2);
        if (fakeVirtualFile == null) {
            TempFileSystem.$$$reportNull$$$0(10);
        }
        return fakeVirtualFile;
    }

    @Nullable
    public VirtualFile findModelChild(@NotNull VirtualFile parent, @NotNull String name) {
        FSItem child;
        if (parent == null) {
            TempFileSystem.$$$reportNull$$$0(11);
        }
        if (name == null) {
            TempFileSystem.$$$reportNull$$$0(12);
        }
        return (child = this.convertDirectory(parent).findChild(name)) == null ? null : new FakeVirtualFile(parent, name);
    }

    @Override
    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(13);
        }
        if (newParent == null) {
            TempFileSystem.$$$reportNull$$$0(14);
        }
        if (copyName == null) {
            TempFileSystem.$$$reportNull$$$0(15);
        }
        VirtualFile virtualFile = VfsUtilCore.copyFile((Object)requestor, (VirtualFile)file2, (VirtualFile)newParent, (String)copyName);
        if (virtualFile == null) {
            TempFileSystem.$$$reportNull$$$0(16);
        }
        return virtualFile;
    }

    @Override
    public void deleteFile(Object requestor, @NotNull VirtualFile file2) {
        FSItem fsItem;
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(17);
        }
        if ((fsItem = this.convert(file2)) == null) {
            FSRecords.invalidateCaches();
            throw new IllegalStateException("failed to delete file " + file2.getPath());
        }
        fsItem.getParent().removeChild(fsItem);
    }

    @Override
    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(18);
        }
        if (newParent == null) {
            TempFileSystem.$$$reportNull$$$0(19);
        }
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null) : "failed to move file " + file2.getPath();
        FSItem newParentItem = this.convert(newParent);
        assert (newParentItem != null && newParentItem.isDirectory()) : "failed to find move target " + file2.getPath();
        FSDir newDir = (FSDir)newParentItem;
        if (newDir.findChild(file2.getName()) != null) {
            throw new IOException("Directory already contains a file named " + file2.getName());
        }
        fsItem.getParent().removeChild(fsItem);
        newDir.addChild(fsItem);
        fsItem.myParent = newDir;
    }

    @Override
    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(20);
        }
        if (newName == null) {
            TempFileSystem.$$$reportNull$$$0(21);
        }
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null);
        fsItem.setName(newName);
    }

    @Override
    @NotNull
    public String getProtocol() {
        if ("temp" == null) {
            TempFileSystem.$$$reportNull$$$0(22);
        }
        return "temp";
    }

    @Override
    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        if (fileOrDirectory == null) {
            TempFileSystem.$$$reportNull$$$0(23);
        }
        return this.convert(fileOrDirectory) != null;
    }

    @Override
    @NotNull
    public String[] list(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(24);
        }
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null);
        String[] stringArray = fsItem.list();
        if (stringArray == null) {
            TempFileSystem.$$$reportNull$$$0(25);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String getCanonicallyCasedName(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(26);
        }
        String string = file2.getName();
        if (string == null) {
            TempFileSystem.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Override
    public boolean isDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(28);
        }
        return this.convert(file2) instanceof FSDir;
    }

    @Override
    public long getTimeStamp(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(29);
        }
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null) : "cannot find item for path " + file2.getPath();
        return fsItem.myTimestamp;
    }

    @Override
    public void setTimeStamp(@NotNull VirtualFile file2, long timeStamp) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(30);
        }
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null);
        fsItem.myTimestamp = timeStamp > 0L ? timeStamp : LocalTimeCounter.currentTime();
    }

    @Override
    public boolean isWritable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(31);
        }
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null);
        return fsItem.myWritable;
    }

    @Override
    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(32);
        }
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null);
        fsItem.myWritable = writableFlag;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        FSItem fsItem;
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(33);
        }
        if ((fsItem = this.convert(file2)) == null) {
            throw new FileNotFoundException("Cannot find temp for " + file2.getPath());
        }
        assert (fsItem instanceof FSFile) : fsItem;
        byte[] byArray = ((FSFile)fsItem).myContent;
        if (byArray == null) {
            TempFileSystem.$$$reportNull$$$0(34);
        }
        return byArray;
    }

    @Override
    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(35);
        }
        BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream = new BufferExposingByteArrayInputStream(this.contentsToByteArray(file2));
        if (bufferExposingByteArrayInputStream == null) {
            TempFileSystem.$$$reportNull$$$0(36);
        }
        return bufferExposingByteArrayInputStream;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(final @NotNull VirtualFile file2, Object requestor, final long modStamp, long l) throws IOException {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(37);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                FSItem fsItem = TempFileSystem.this.convert(file2);
                assert (fsItem instanceof FSFile);
                FSFile.access$302((FSFile)fsItem, this.toByteArray());
                TempFileSystem.this.setTimeStamp(file2, modStamp);
            }
        };
        if (byteArrayOutputStream == null) {
            TempFileSystem.$$$reportNull$$$0(38);
        }
        return byteArrayOutputStream;
    }

    @Override
    public long getLength(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(39);
        }
        try {
            return this.contentsToByteArray(file2).length;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        FSItem item;
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(40);
        }
        if ((item = this.convert(file2)) == null) {
            return null;
        }
        long length = item instanceof FSFile ? (long)((FSFile)item).myContent.length : 0L;
        return new FileAttributes(item.isDirectory(), false, false, false, length, item.myTimestamp, item.myWritable);
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequests, @Nullable Collection<String> recursiveRoots, @Nullable Collection<String> flatRoots) {
        if (watchRequests == null) {
            TempFileSystem.$$$reportNull$$$0(41);
        }
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    protected String normalize(@NotNull String path) {
        if (path == null) {
            TempFileSystem.$$$reportNull$$$0(42);
        }
        String string = path;
        if (string == null) {
            TempFileSystem.$$$reportNull$$$0(43);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 16: 
            case 22: 
            case 25: 
            case 27: 
            case 34: 
            case 36: 
            case 38: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 16: 
            case 22: 
            case 25: 
            case 27: 
            case 34: 
            case 36: 
            case 38: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 16: 
            case 22: 
            case 25: 
            case 27: 
            case 34: 
            case 36: 
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem";
                break;
            }
            case 2: 
            case 9: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRootPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicallyCasedName";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 16: 
            case 22: 
            case 25: 
            case 27: 
            case 34: 
            case 36: 
            case 38: 
            case 43: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertDirectory";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findModelChild";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicallyCasedName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "replaceWatchedRoots";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 16: 
            case 22: 
            case 25: 
            case 27: 
            case 34: 
            case 36: 
            case 38: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FSFile
    extends FSItem {
        private byte[] myContent;

        FSFile(@NotNull FSDir parent, @NotNull String name) {
            if (parent == null) {
                FSFile.$$$reportNull$$$0(0);
            }
            if (name == null) {
                FSFile.$$$reportNull$$$0(1);
            }
            super(parent, name);
            this.myContent = new byte[0];
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        static /* synthetic */ byte[] access$302(FSFile x0, byte[] x1) {
            x0.myContent = x1;
            return x1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem$FSFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FSDir
    extends FSItem {
        private final Map<String, FSItem> myChildren;

        FSDir(@Nullable FSDir parent, @NotNull String name) {
            if (name == null) {
                FSDir.$$$reportNull$$$0(0);
            }
            super(parent, name);
            this.myChildren = new LinkedHashMap<String, FSItem>();
        }

        @Override
        @Nullable
        public FSItem findChild(String name) {
            return this.myChildren.get(name);
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        void addChild(@NotNull FSItem item) {
            if (item == null) {
                FSDir.$$$reportNull$$$0(1);
            }
            this.myChildren.put(item.myName, item);
        }

        void removeChild(@NotNull FSItem fsItem) {
            if (fsItem == null) {
                FSDir.$$$reportNull$$$0(2);
            }
            if (fsItem.myName.equals("src") && this.getParent() == null) {
                throw new RuntimeException("removing src directory");
            }
            this.myChildren.remove(fsItem.myName);
        }

        @Override
        @NotNull
        public String[] list() {
            String[] stringArray = ArrayUtil.toStringArray(this.myChildren.keySet());
            if (stringArray == null) {
                FSDir.$$$reportNull$$$0(3);
            }
            return stringArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fsItem";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem$FSDir";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem$FSDir";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addChild";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "removeChild";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class FSItem {
        private FSDir myParent;
        private String myName;
        private long myTimestamp;
        private boolean myWritable;

        FSItem(@Nullable FSDir parent, @NotNull String name) {
            if (name == null) {
                FSItem.$$$reportNull$$$0(0);
            }
            this.myParent = parent;
            this.myName = name;
            this.myTimestamp = LocalTimeCounter.currentTime();
            this.myWritable = true;
        }

        public abstract boolean isDirectory();

        @Nullable
        public FSItem findChild(String name) {
            return null;
        }

        void setName(@NotNull String name) {
            if (name == null) {
                FSItem.$$$reportNull$$$0(1);
            }
            this.myParent.myChildren.remove(this.myName);
            this.myName = name;
            this.myParent.myChildren.put(name, this);
        }

        public FSDir getParent() {
            return this.myParent;
        }

        @NotNull
        public String[] list() {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                FSItem.$$$reportNull$$$0(2);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.myName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem$FSItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem$FSItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

