/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiCommentManipulator
extends AbstractElementManipulator<PsiComment> {
    public PsiComment handleContentChange(@NotNull PsiComment psiComment, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (psiComment == null) {
            PsiCommentManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            PsiCommentManipulator.$$$reportNull$$$0(1);
        }
        String oldText = psiComment.getText();
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        FileType type = psiComment.getContainingFile().getFileType();
        PsiFile fromText = PsiFileFactory.getInstance((Project)psiComment.getProject()).createFileFromText("__." + type.getDefaultExtension(), type, (CharSequence)newText);
        PsiComment newElement = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)fromText.findElementAt(0), psiComment.getClass(), (boolean)false);
        assert (newElement != null) : type + " " + type.getDefaultExtension() + " " + newText;
        return (PsiComment)psiComment.replace((PsiElement)newElement);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull PsiComment element) {
        String text;
        if (element == null) {
            PsiCommentManipulator.$$$reportNull$$$0(2);
        }
        if ((text = element.getText()).startsWith("//")) {
            TextRange textRange = new TextRange(2, element.getTextLength());
            if (textRange == null) {
                PsiCommentManipulator.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        int length = text.length();
        if (length > 4 && text.startsWith("/**") && text.endsWith("*/")) {
            TextRange textRange = new TextRange(3, element.getTextLength() - 2);
            if (textRange == null) {
                PsiCommentManipulator.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        if (length > 3 && text.startsWith("/*") && text.endsWith("*/")) {
            TextRange textRange = new TextRange(2, element.getTextLength() - 2);
            if (textRange == null) {
                PsiCommentManipulator.$$$reportNull$$$0(5);
            }
            return textRange;
        }
        if (length > 6 && text.startsWith("<!--") && text.endsWith("-->")) {
            TextRange textRange = new TextRange(4, element.getTextLength() - 3);
            if (textRange == null) {
                PsiCommentManipulator.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        if (text.startsWith("--")) {
            TextRange textRange = new TextRange(2, element.getTextLength());
            if (textRange == null) {
                PsiCommentManipulator.$$$reportNull$$$0(7);
            }
            return textRange;
        }
        if (text.startsWith("#")) {
            TextRange textRange = new TextRange(1, element.getTextLength());
            if (textRange == null) {
                PsiCommentManipulator.$$$reportNull$$$0(8);
            }
            return textRange;
        }
        TextRange textRange = super.getRangeInElement((PsiElement)element);
        if (textRange == null) {
            PsiCommentManipulator.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiComment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiCommentManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiCommentManipulator";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

