/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.inspections.SpellCheckingInspection;
import com.intellij.ui.SimpleEditorCustomization;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class SpellCheckingEditorCustomization
extends SimpleEditorCustomization {
    public static final SpellCheckingEditorCustomization ENABLED = (SpellCheckingEditorCustomization)SpellCheckingEditorCustomizationProvider.getInstance().getEnabledCustomization();
    public static final SpellCheckingEditorCustomization DISABLED = (SpellCheckingEditorCustomization)SpellCheckingEditorCustomizationProvider.getInstance().getDisabledCustomization();
    private static final Map<String, LocalInspectionToolWrapper> SPELL_CHECK_TOOLS = new HashMap<String, LocalInspectionToolWrapper>();
    private static final boolean READY = SpellCheckingEditorCustomization.init();

    @NotNull
    public static SpellCheckingEditorCustomization getInstance(boolean enabled) {
        SpellCheckingEditorCustomization spellCheckingEditorCustomization = (SpellCheckingEditorCustomization)SpellCheckingEditorCustomizationProvider.getInstance().getCustomization(enabled);
        if (spellCheckingEditorCustomization == null) {
            SpellCheckingEditorCustomization.$$$reportNull$$$0(0);
        }
        return spellCheckingEditorCustomization;
    }

    SpellCheckingEditorCustomization(boolean enabled) {
        super(enabled);
    }

    private static boolean init() {
        Class[] inspectionClasses;
        for (Class inspectionClass : inspectionClasses = new Class[]{SpellCheckingInspection.class}) {
            try {
                LocalInspectionTool tool = (LocalInspectionTool)inspectionClass.newInstance();
                SPELL_CHECK_TOOLS.put(tool.getShortName(), new LocalInspectionToolWrapper(tool));
            }
            catch (Throwable e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void customize(@NotNull EditorEx editor) {
        DaemonCodeAnalyzer analyzer;
        if (editor == null) {
            SpellCheckingEditorCustomization.$$$reportNull$$$0(1);
        }
        boolean apply2 = this.isEnabled();
        if (!READY) {
            return;
        }
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile((Document)editor.getDocument());
        if (file2 == null) {
            return;
        }
        Function strategy = (Function)file2.getUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY);
        if (strategy == null) {
            strategy = new MyInspectionProfileStrategy();
            file2.putUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY, (Object)strategy);
        }
        if (!(strategy instanceof MyInspectionProfileStrategy)) {
            return;
        }
        ((MyInspectionProfileStrategy)strategy).setUseSpellCheck(apply2);
        if (apply2) {
            editor.putUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY, false);
        }
        if ((analyzer = DaemonCodeAnalyzer.getInstance((Project)project)) != null) {
            analyzer.restart(file2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyInspectionProfileWrapper
    extends InspectionProfileWrapper {
        private boolean myUseSpellCheck;

        MyInspectionProfileWrapper() {
            super(new InspectionProfileImpl("CommitDialog"));
        }

        @Override
        public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element) {
            return SPELL_CHECK_TOOLS.containsKey(key.toString()) ? this.myUseSpellCheck : super.isToolEnabled(key, element);
        }

        public void setUseSpellCheck(boolean useSpellCheck) {
            this.myUseSpellCheck = useSpellCheck;
        }
    }

    private static class MyInspectionProfileStrategy
    implements Function<InspectionProfileImpl, InspectionProfileWrapper> {
        private final Map<InspectionProfile, MyInspectionProfileWrapper> myWrappers = ContainerUtil.createWeakMap();
        private boolean myUseSpellCheck;

        private MyInspectionProfileStrategy() {
        }

        @Override
        @NotNull
        public InspectionProfileWrapper apply(@NotNull InspectionProfileImpl inspectionProfile) {
            if (inspectionProfile == null) {
                MyInspectionProfileStrategy.$$$reportNull$$$0(0);
            }
            if (!READY) {
                InspectionProfileWrapper inspectionProfileWrapper = new InspectionProfileWrapper(inspectionProfile);
                if (inspectionProfileWrapper == null) {
                    MyInspectionProfileStrategy.$$$reportNull$$$0(1);
                }
                return inspectionProfileWrapper;
            }
            MyInspectionProfileWrapper wrapper2 = this.myWrappers.get(inspectionProfile);
            if (wrapper2 == null) {
                wrapper2 = new MyInspectionProfileWrapper();
                this.myWrappers.put(inspectionProfile, wrapper2);
            }
            wrapper2.setUseSpellCheck(this.myUseSpellCheck);
            MyInspectionProfileWrapper myInspectionProfileWrapper = wrapper2;
            if (myInspectionProfileWrapper == null) {
                MyInspectionProfileStrategy.$$$reportNull$$$0(2);
            }
            return myInspectionProfileWrapper;
        }

        public void setUseSpellCheck(boolean useSpellCheck) {
            this.myUseSpellCheck = useSpellCheck;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspectionProfile";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization$MyInspectionProfileStrategy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization$MyInspectionProfileStrategy";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

