/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.util.concurrent.atomic.AtomicInteger;

public class JDK7WindowReorderingWorkaround {
    private static AtomicInteger requestorCount = new AtomicInteger();
    private static final Callback windowDidBecomeMainCallback = new Callback(){

        public void callback(ID self, ID nsNotification) {
            if (requestorCount.intValue() == 0) {
                Foundation.invoke((ID)self, (String)"oldWindowDidBecomeMain:", (Object[])new Object[]{nsNotification});
            }
        }
    };
    private static final Callback canBecomeMainWindowCallback = new Callback(){

        public void callback(ID self) {
            if (requestorCount.intValue() == 0) {
                Foundation.invoke((ID)self, (String)"oldCanBecomeMainWindow", (Object[])new Object[0]);
            }
        }
    };

    static void disableReordering() {
        if (SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
            requestorCount.incrementAndGet();
        }
    }

    static void enableReordering() {
        if (SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
            requestorCount.decrementAndGet();
        }
    }

    static {
        if (SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
            ID awtWindow = Foundation.getObjcClass((String)"AWTWindow");
            Pointer windowDidBecomeMainMethod = Foundation.createSelector((String)"windowDidBecomeMain:");
            ID originalWindowDidBecomeMain = Foundation.class_replaceMethod((ID)awtWindow, (Pointer)windowDidBecomeMainMethod, (Callback)windowDidBecomeMainCallback, (String)"v@::@");
            Foundation.addMethodByID((ID)awtWindow, (Pointer)Foundation.createSelector((String)"oldWindowDidBecomeMain:"), (ID)originalWindowDidBecomeMain, (String)"v@::@");
            if (SystemInfo.isJavaVersionAtLeast((String)"1.8")) {
                Pointer canBecomeMainWindowMethod = Foundation.createSelector((String)"canBecomeMainWindow");
                ID originalCanBecomeMainWindow = Foundation.class_replaceMethod((ID)awtWindow, (Pointer)canBecomeMainWindowMethod, (Callback)canBecomeMainWindowCallback, (String)"v@B");
                Foundation.addMethodByID((ID)awtWindow, (Pointer)Foundation.createSelector((String)"oldCanBecomeMainWindow"), (ID)originalCanBecomeMainWindow, (String)"v@B");
            }
        }
    }
}

