/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabsWatcher;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VisiblePackRefresherImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogManager.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogTabsProperties myUiProperties;
    @Nullable
    private final Consumer<Throwable> myRecreateMainLogHandler;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogColorManagerImpl myColorManager;
    @NotNull
    private final VcsLogTabsWatcher myTabsLogRefresher;
    @NotNull
    private final PostponableLogRefresher myPostponableRefresher;
    private boolean myInitialized;

    public VcsLogManager(@NotNull Project project, @NotNull VcsLogTabsProperties uiProperties, @NotNull Collection<VcsRoot> roots) {
        if (project == null) {
            VcsLogManager.$$$reportNull$$$0(0);
        }
        if (uiProperties == null) {
            VcsLogManager.$$$reportNull$$$0(1);
        }
        if (roots == null) {
            VcsLogManager.$$$reportNull$$$0(2);
        }
        this(project, uiProperties, roots, true, null);
    }

    public VcsLogManager(@NotNull Project project, @NotNull VcsLogTabsProperties uiProperties, @NotNull Collection<VcsRoot> roots, boolean scheduleRefreshImmediately, @Nullable Consumer<Throwable> recreateHandler) {
        if (project == null) {
            VcsLogManager.$$$reportNull$$$0(3);
        }
        if (uiProperties == null) {
            VcsLogManager.$$$reportNull$$$0(4);
        }
        if (roots == null) {
            VcsLogManager.$$$reportNull$$$0(5);
        }
        this.myInitialized = false;
        this.myProject = project;
        this.myUiProperties = uiProperties;
        this.myRecreateMainLogHandler = recreateHandler;
        Map<VirtualFile, VcsLogProvider> logProviders = VcsLogManager.findLogProviders(roots, this.myProject);
        this.myLogData = new VcsLogData(this.myProject, logProviders, new MyFatalErrorsHandler(), this);
        this.myPostponableRefresher = new PostponableLogRefresher(this.myLogData);
        this.myTabsLogRefresher = new VcsLogTabsWatcher(this.myProject, this.myPostponableRefresher);
        VcsLogManager.refreshLogOnVcsEvents(logProviders, this.myPostponableRefresher, this.myLogData);
        this.myColorManager = new VcsLogColorManagerImpl(logProviders.keySet());
        if (scheduleRefreshImmediately) {
            this.scheduleInitialization();
        }
    }

    public void scheduleInitialization() {
        if (!this.myInitialized) {
            this.myInitialized = true;
            this.myLogData.initialize();
        }
    }

    public boolean isLogVisible() {
        return this.myPostponableRefresher.isLogVisible();
    }

    @NotNull
    public VcsLogData getDataManager() {
        VcsLogData vcsLogData = this.myLogData;
        if (vcsLogData == null) {
            VcsLogManager.$$$reportNull$$$0(6);
        }
        return vcsLogData;
    }

    @NotNull
    public VcsLogUiImpl createLogUi(@NotNull String logId, @Nullable String contentTabName) {
        if (logId == null) {
            VcsLogManager.$$$reportNull$$$0(7);
        }
        VcsLogUiImpl vcsLogUiImpl = this.createLogUi(contentTabName, this.getMainLogUiFactory(logId));
        if (vcsLogUiImpl == null) {
            VcsLogManager.$$$reportNull$$$0(8);
        }
        return vcsLogUiImpl;
    }

    @NotNull
    public VcsLogUiFactory<? extends VcsLogUiImpl> getMainLogUiFactory(@NotNull String logId) {
        if (logId == null) {
            VcsLogManager.$$$reportNull$$$0(9);
        }
        MainVcsLogUiFactory mainVcsLogUiFactory = new MainVcsLogUiFactory(logId);
        if (mainVcsLogUiFactory == null) {
            VcsLogManager.$$$reportNull$$$0(10);
        }
        return mainVcsLogUiFactory;
    }

    @NotNull
    public <U extends AbstractVcsLogUi> U createLogUi(@Nullable String contentTabName, @NotNull VcsLogUiFactory<U> factory) {
        if (factory == null) {
            VcsLogManager.$$$reportNull$$$0(11);
        }
        U ui = factory.createLogUi(this.myProject, this.myLogData, this.myColorManager);
        Disposable disposable = contentTabName != null ? this.myTabsLogRefresher.addTabToWatch(contentTabName, ((AbstractVcsLogUi)ui).getRefresher()) : this.myPostponableRefresher.addLogWindow(((AbstractVcsLogUi)ui).getRefresher());
        Disposer.register(ui, (Disposable)disposable);
        ((AbstractVcsLogUi)ui).requestFocus();
        U u = ui;
        if (u == null) {
            VcsLogManager.$$$reportNull$$$0(12);
        }
        return u;
    }

    private static void refreshLogOnVcsEvents(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsLogRefresher refresher, @NotNull Disposable disposableParent) {
        if (logProviders == null) {
            VcsLogManager.$$$reportNull$$$0(13);
        }
        if (refresher == null) {
            VcsLogManager.$$$reportNull$$$0(14);
        }
        if (disposableParent == null) {
            VcsLogManager.$$$reportNull$$$0(15);
        }
        MultiMap providers2roots = MultiMap.create();
        logProviders.forEach((key, value) -> providers2roots.putValue(value, key));
        for (Map.Entry entry : providers2roots.entrySet()) {
            Disposable disposable = ((VcsLogProvider)entry.getKey()).subscribeToRootRefreshEvents((Collection)entry.getValue(), refresher);
            Disposer.register((Disposable)disposableParent, (Disposable)disposable);
        }
    }

    @NotNull
    public static Map<VirtualFile, VcsLogProvider> findLogProviders(@NotNull Collection<VcsRoot> roots, @NotNull Project project) {
        if (roots == null) {
            VcsLogManager.$$$reportNull$$$0(16);
        }
        if (project == null) {
            VcsLogManager.$$$reportNull$$$0(17);
        }
        HashMap logProviders = ContainerUtil.newHashMap();
        VcsLogProvider[] allLogProviders = (VcsLogProvider[])Extensions.getExtensions((ExtensionPointName)VcsLogProvider.LOG_PROVIDER_EP, (AreaInstance)project);
        block0: for (VcsRoot root : roots) {
            AbstractVcs vcs = root.getVcs();
            VirtualFile path = root.getPath();
            if (vcs == null || path == null) {
                LOG.error("Skipping invalid VCS root: " + root);
                continue;
            }
            for (VcsLogProvider provider : allLogProviders) {
                if (!provider.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())) continue;
                logProviders.put(path, provider);
                continue block0;
            }
        }
        HashMap hashMap = logProviders;
        if (hashMap == null) {
            VcsLogManager.$$$reportNull$$$0(18);
        }
        return hashMap;
    }

    public void dispose(@Nullable Runnable callback) {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        this.myTabsLogRefresher.closeLogTabs();
        Disposer.dispose((Disposable)this.myTabsLogRefresher);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Disposer.dispose((Disposable)this);
            if (callback != null) {
                callback.run();
            }
        });
    }

    public void dispose() {
        LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 2: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogManager";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataManager";
                break;
            }
            case 8: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogUi";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainLogUiFactory";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findLogProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 18: {
                break;
            }
            case 7: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createLogUi";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMainLogUiFactory";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "refreshLogOnVcsEvents";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findLogProviders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MainVcsLogUiFactory
    implements VcsLogUiFactory<VcsLogUiImpl> {
        private final String myLogId;

        public MainVcsLogUiFactory(String logId) {
            if (logId == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(0);
            }
            this.myLogId = logId;
        }

        @Override
        public VcsLogUiImpl createLogUi(@NotNull Project project, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager) {
            if (project == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(1);
            }
            if (logData == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(2);
            }
            if (manager == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(3);
            }
            MainVcsLogUiProperties properties = VcsLogManager.this.myUiProperties.createProperties(this.myLogId);
            VisiblePackRefresherImpl refresher = new VisiblePackRefresherImpl(project, logData, properties.get(MainVcsLogUiProperties.BEK_SORT_TYPE), new VcsLogFilterer(logData.getLogProviders(), logData.getStorage(), logData.getTopCommitsCache(), logData.getCommitDetailsGetter(), logData.getIndex()));
            return new VcsLogUiImpl(logData, project, manager, properties, refresher);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogManager$MainVcsLogUiFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createLogUi";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    public static interface VcsLogUiFactory<T extends AbstractVcsLogUi> {
        public T createLogUi(@NotNull Project var1, @NotNull VcsLogData var2, @NotNull VcsLogColorManager var3);
    }

    private class MyFatalErrorsHandler
    implements FatalErrorHandler {
        private final AtomicBoolean myIsBroken = new AtomicBoolean(false);

        private MyFatalErrorsHandler() {
        }

        @Override
        public void consume(@Nullable Object source, @NotNull Throwable e) {
            if (e == null) {
                MyFatalErrorsHandler.$$$reportNull$$$0(0);
            }
            if (this.myIsBroken.compareAndSet(false, true)) {
                this.processError(source, e);
            } else {
                LOG.debug("Vcs Log storage is broken and is being recreated", e);
            }
        }

        protected void processError(@Nullable Object source, @NotNull Throwable e) {
            if (e == null) {
                MyFatalErrorsHandler.$$$reportNull$$$0(1);
            }
            if (VcsLogManager.this.myRecreateMainLogHandler != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (e == null) {
                        MyFatalErrorsHandler.$$$reportNull$$$0(3);
                    }
                    VcsLogManager.this.myRecreateMainLogHandler.consume((Object)e);
                });
            } else {
                LOG.error(e);
            }
            if (source instanceof VcsLogStorage) {
                VcsLogManager.this.myLogData.getIndex().markCorrupted();
            }
        }

        @Override
        public void displayFatalErrorMessage(@NotNull String message) {
            if (message == null) {
                MyFatalErrorsHandler.$$$reportNull$$$0(2);
            }
            VcsBalloonProblemNotifier.showOverChangesView(VcsLogManager.this.myProject, message, MessageType.ERROR, new NamedRunnable[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogManager$MyFatalErrorsHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "consume";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processError";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "displayFatalErrorMessage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$processError$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

