/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u0016\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vfs/AsyncVfsEventsPostProcessorImpl;", "Lcom/intellij/vfs/AsyncVfsEventsPostProcessor;", "Lcom/intellij/openapi/Disposable;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "listeners", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/intellij/vfs/AsyncVfsEventsPostProcessorImpl$ListenerAndDisposable;", "kotlin.jvm.PlatformType", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "queue", "Lcom/intellij/util/concurrency/QueueProcessor;", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "addListener", "", "listener", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "disposable", "dispose", "processEvents", "events", "ListenerAndDisposable", "vcs-impl"})
public final class AsyncVfsEventsPostProcessorImpl
implements AsyncVfsEventsPostProcessor,
Disposable {
    private final Logger LOG;
    private final QueueProcessor<List<VFileEvent>> queue;
    private final MessageBus messageBus;
    private final ConcurrentList<ListenerAndDisposable> listeners;

    public void addListener(@NotNull AsyncVfsEventsListener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
        ListenerAndDisposable element = new ListenerAndDisposable(listener2, disposable);
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(this, element){
            final /* synthetic */ AsyncVfsEventsPostProcessorImpl this$0;
            final /* synthetic */ ListenerAndDisposable $element;

            public final void dispose() {
                AsyncVfsEventsPostProcessorImpl.access$getListeners$p(this.this$0).remove((Object)this.$element);
            }
            {
                this.this$0 = asyncVfsEventsPostProcessorImpl;
                this.$element = listenerAndDisposable;
            }
        });
        this.listeners.add((Object)element);
    }

    public void dispose() {
        this.queue.clear();
        this.listeners.clear();
    }

    private final void processEvents(List<? extends VFileEvent> events) {
        for (ListenerAndDisposable listenerAndDisposable : this.listeners) {
            AsyncVfsEventsListener listener2 = listenerAndDisposable.component1();
            Disposable parentDisposable = listenerAndDisposable.component2();
            try {
                BackgroundTaskUtil.runUnderDisposeAwareIndicator(parentDisposable, new Runnable(listener2, events){
                    final /* synthetic */ AsyncVfsEventsListener $listener;
                    final /* synthetic */ List $events;

                    public final void run() {
                        this.$listener.filesChanged(this.$events);
                    }
                    {
                        this.$listener = asyncVfsEventsListener;
                        this.$events = list2;
                    }
                });
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e) {
                this.LOG.error(e);
            }
        }
    }

    public AsyncVfsEventsPostProcessorImpl() {
        Logger logger;
        AsyncVfsEventsPostProcessorImpl asyncVfsEventsPostProcessorImpl = this;
        Logger logger2 = Logger.getInstance(AsyncVfsEventsPostProcessorImpl.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        asyncVfsEventsPostProcessorImpl.LOG = logger = logger2;
        this.queue = new QueueProcessor(new Consumer<T>(this){
            final /* synthetic */ AsyncVfsEventsPostProcessorImpl this$0;

            public final void consume(List<? extends VFileEvent> events) {
                List<? extends VFileEvent> list2 = events;
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"events");
                AsyncVfsEventsPostProcessorImpl.access$processEvents(this.this$0, list2);
            }
            {
                this.this$0 = asyncVfsEventsPostProcessorImpl;
            }
        });
        this.messageBus = ApplicationManager.getApplication().getMessageBus();
        this.listeners = ContainerUtil.createConcurrentList();
        this.messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                queue.add(events);
            }
        });
    }

    @NotNull
    public static final /* synthetic */ ConcurrentList access$getListeners$p(AsyncVfsEventsPostProcessorImpl $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ void access$processEvents(AsyncVfsEventsPostProcessorImpl $this, @NotNull List events) {
        $this.processEvents(events);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vfs/AsyncVfsEventsPostProcessorImpl$ListenerAndDisposable;", "", "listener", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/vfs/AsyncVfsEventsListener;Lcom/intellij/openapi/Disposable;)V", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "getListener", "()Lcom/intellij/vfs/AsyncVfsEventsListener;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "vcs-impl"})
    private static final class ListenerAndDisposable {
        @NotNull
        private final AsyncVfsEventsListener listener;
        @NotNull
        private final Disposable disposable;

        @NotNull
        public final AsyncVfsEventsListener getListener() {
            return this.listener;
        }

        @NotNull
        public final Disposable getDisposable() {
            return this.disposable;
        }

        public ListenerAndDisposable(@NotNull AsyncVfsEventsListener listener2, @NotNull Disposable disposable) {
            Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
            Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
            this.listener = listener2;
            this.disposable = disposable;
        }

        @NotNull
        public final AsyncVfsEventsListener component1() {
            return this.listener;
        }

        @NotNull
        public final Disposable component2() {
            return this.disposable;
        }

        @NotNull
        public final ListenerAndDisposable copy(@NotNull AsyncVfsEventsListener listener2, @NotNull Disposable disposable) {
            Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
            Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
            return new ListenerAndDisposable(listener2, disposable);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ListenerAndDisposable copy$default(ListenerAndDisposable listenerAndDisposable, AsyncVfsEventsListener asyncVfsEventsListener, Disposable disposable, int n, Object object) {
            if ((n & 1) != 0) {
                asyncVfsEventsListener = listenerAndDisposable.listener;
            }
            if ((n & 2) != 0) {
                disposable = listenerAndDisposable.disposable;
            }
            return listenerAndDisposable.copy(asyncVfsEventsListener, disposable);
        }

        public String toString() {
            return "ListenerAndDisposable(listener=" + this.listener + ", disposable=" + this.disposable + ")";
        }

        public int hashCode() {
            AsyncVfsEventsListener asyncVfsEventsListener = this.listener;
            Disposable disposable = this.disposable;
            return (asyncVfsEventsListener != null ? asyncVfsEventsListener.hashCode() : 0) * 31 + (disposable != null ? disposable.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ListenerAndDisposable)) break block3;
                    ListenerAndDisposable listenerAndDisposable = (ListenerAndDisposable)object;
                    if (!Intrinsics.areEqual((Object)this.listener, (Object)listenerAndDisposable.listener) || !Intrinsics.areEqual((Object)this.disposable, (Object)listenerAndDisposable.disposable)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

