/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.openapi.vfs.ex.http.HttpVirtualFileListener;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.BreakpointState;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.LineBreakpointState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointManagerImpl
implements XBreakpointManager,
PersistentStateComponent<BreakpointManagerState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl");
    public static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTER = new SkipDefaultValuesSerializationFilters();
    private final MultiValuesMap<XBreakpointType, XBreakpointBase<?, ?, ?>> myBreakpoints = new MultiValuesMap(true);
    private final Map<XBreakpointType, XBreakpointBase<?, ?, ?>> myDefaultBreakpoints = new LinkedHashMap();
    private final Map<XBreakpointType, BreakpointState<?, ?, ?>> myBreakpointsDefaults = new LinkedHashMap();
    private final Set<XBreakpointBase<?, ?, ?>> myAllBreakpoints = new HashSet();
    private final Map<XBreakpointType, EventDispatcher<XBreakpointListener>> myDispatchers = new HashMap<XBreakpointType, EventDispatcher<XBreakpointListener>>();
    private XBreakpointsDialogState myBreakpointsDialogSettings;
    private final EventDispatcher<XBreakpointListener> myAllBreakpointsDispatcher;
    private final XLineBreakpointManager myLineBreakpointManager;
    private final Project myProject;
    private final XDebuggerManagerImpl myDebuggerManager;
    private final XDependentBreakpointManager myDependentBreakpointManager;
    private long myTime;
    private String myDefaultGroup;

    public XBreakpointManagerImpl(Project project, XDebuggerManagerImpl debuggerManager, StartupManager startupManager) {
        this.myProject = project;
        this.myDebuggerManager = debuggerManager;
        this.myAllBreakpointsDispatcher = EventDispatcher.create(XBreakpointListener.class);
        this.myDependentBreakpointManager = new XDependentBreakpointManager(this);
        this.myLineBreakpointManager = new XLineBreakpointManager(project, this.myDependentBreakpointManager, startupManager);
        if (!project.isDefault()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                HttpVirtualFileListener httpVirtualFileListener = this::updateBreakpointInFile;
                HttpFileSystem.getInstance().addFileListener(httpVirtualFileListener, (Disposable)project);
            }
            XBreakpointUtil.breakpointTypes().forEach(this::addDefaultBreakpoint);
        }
    }

    private void updateBreakpointInFile(VirtualFile file2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            for (XBreakpointBase<?, ?, ?> breakpoint : this.getAllBreakpoints()) {
                XSourcePosition position = breakpoint.getSourcePosition();
                if (position == null || !Comparing.equal((Object)position.getFile(), (Object)file2)) continue;
                this.fireBreakpointChanged(breakpoint);
            }
        });
    }

    public XLineBreakpointManager getLineBreakpointManager() {
        return this.myLineBreakpointManager;
    }

    public XDependentBreakpointManager getDependentBreakpointManager() {
        return this.myDependentBreakpointManager;
    }

    public XDebuggerManagerImpl getDebuggerManager() {
        return this.myDebuggerManager;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public <T extends XBreakpointProperties> XBreakpoint<T> addBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, @Nullable T properties) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XBreakpointBase<?, T, ?> breakpoint = this.createBreakpoint(type, properties, true, false);
        this.addBreakpoint(breakpoint, false, true);
        XBreakpointBase<?, T, ?> xBreakpointBase = breakpoint;
        if (xBreakpointBase == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(0);
        }
        return xBreakpointBase;
    }

    private <T extends XBreakpointProperties> XBreakpointBase<?, T, ?> createBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, T properties, boolean enabled, boolean defaultBreakpoint) {
        long l;
        String string = type.getId();
        if (defaultBreakpoint) {
            l = 0L;
        } else {
            long l2 = this.myTime;
            l = l2;
            this.myTime = l2 + 1L;
        }
        BreakpointState state2 = new BreakpointState(enabled, string, l, type.getDefaultSuspendPolicy());
        this.getBreakpointDefaults(type).applyDefaults(state2);
        state2.setGroup(this.myDefaultGroup);
        return new XBreakpointBase(type, this, properties, state2);
    }

    private <T extends XBreakpointProperties> void addBreakpoint(XBreakpointBase<?, T, ?> breakpoint, boolean defaultBreakpoint, boolean initUI) {
        EventDispatcher<XBreakpointListener> dispatcher;
        XBreakpointType<?, T> type = breakpoint.getType();
        if (defaultBreakpoint) {
            LOG.assertTrue(!this.myDefaultBreakpoints.containsKey(type), (Object)("Cannot have more than one default breakpoint (type " + type.getId() + ")"));
            this.myDefaultBreakpoints.put(type, breakpoint);
        } else {
            this.myBreakpoints.put(type, breakpoint);
        }
        this.myAllBreakpoints.add(breakpoint);
        if (breakpoint instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.registerBreakpoint((XLineBreakpointImpl)breakpoint, initUI);
        }
        if ((dispatcher = this.myDispatchers.get(type)) != null) {
            ((XBreakpointListener)dispatcher.getMulticaster()).breakpointAdded(breakpoint);
        }
        this.getBreakpointDispatcherMulticaster().breakpointAdded(breakpoint);
    }

    private XBreakpointListener<XBreakpoint<?>> getBreakpointDispatcherMulticaster() {
        return (XBreakpointListener)this.myAllBreakpointsDispatcher.getMulticaster();
    }

    public void fireBreakpointChanged(XBreakpointBase<?, ?, ?> breakpoint) {
        EventDispatcher<XBreakpointListener> dispatcher;
        if (!this.myAllBreakpoints.contains(breakpoint)) {
            return;
        }
        if (breakpoint instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.breakpointChanged((XLineBreakpointImpl)breakpoint);
        }
        if ((dispatcher = this.myDispatchers.get(breakpoint.getType())) != null) {
            ((XBreakpointListener)dispatcher.getMulticaster()).breakpointChanged(breakpoint);
        }
        this.getBreakpointDispatcherMulticaster().breakpointChanged(breakpoint);
    }

    public void removeBreakpoint(@NotNull XBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.doRemoveBreakpoint(breakpoint);
    }

    private void doRemoveBreakpoint(XBreakpoint<?> breakpoint) {
        if (this.isDefaultBreakpoint(breakpoint)) {
            breakpoint.setEnabled(false);
        } else {
            XBreakpointType type = breakpoint.getType();
            XBreakpointBase breakpointBase = (XBreakpointBase)breakpoint;
            this.myBreakpoints.remove((Object)type, (Object)breakpointBase);
            this.myAllBreakpoints.remove(breakpointBase);
            if (breakpointBase instanceof XLineBreakpointImpl) {
                this.myLineBreakpointManager.unregisterBreakpoint((XLineBreakpointImpl)breakpointBase);
            }
            breakpointBase.dispose();
            EventDispatcher<XBreakpointListener> dispatcher = this.myDispatchers.get(type);
            if (dispatcher != null) {
                ((XBreakpointListener)dispatcher.getMulticaster()).breakpointRemoved(breakpoint);
            }
            this.getBreakpointDispatcherMulticaster().breakpointRemoved(breakpoint);
        }
    }

    @NotNull
    public <T extends XBreakpointProperties> XLineBreakpoint<T> addLineBreakpoint(XLineBreakpointType<T> type, @NotNull String fileUrl, int line, @Nullable T properties) {
        if (fileUrl == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(2);
        }
        XLineBreakpoint<T> xLineBreakpoint = this.addLineBreakpoint(type, fileUrl, line, properties, false);
        if (xLineBreakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(3);
        }
        return xLineBreakpoint;
    }

    @NotNull
    public <T extends XBreakpointProperties> XLineBreakpoint<T> addLineBreakpoint(XLineBreakpointType<T> type, @NotNull String fileUrl, int line, @Nullable T properties, boolean temporary) {
        if (fileUrl == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LineBreakpointState state2 = new LineBreakpointState(true, type.getId(), fileUrl, line, temporary, this.myTime++, type.getDefaultSuspendPolicy());
        this.getBreakpointDefaults((XBreakpointType)type).applyDefaults(state2);
        state2.setGroup(this.myDefaultGroup);
        XLineBreakpointImpl<T> breakpoint = new XLineBreakpointImpl<T>(type, this, properties, state2);
        this.addBreakpoint(breakpoint, false, true);
        XLineBreakpointImpl<T> xLineBreakpointImpl = breakpoint;
        if (xLineBreakpointImpl == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(5);
        }
        return xLineBreakpointImpl;
    }

    @NotNull
    public XBreakpointBase<?, ?, ?>[] getAllBreakpoints() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XBreakpointBase[] xBreakpointBaseArray = this.myAllBreakpoints.toArray(new XBreakpointBase[this.myAllBreakpoints.size()]);
        if (xBreakpointBaseArray == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(6);
        }
        return xBreakpointBaseArray;
    }

    @NotNull
    public <B extends XBreakpoint<?>> Collection<? extends B> getBreakpoints(@NotNull XBreakpointType<B, ?> type) {
        Collection breakpoints;
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList<B> result2 = new ArrayList<B>();
        B defaultBreakpoint = this.getDefaultBreakpoint(type);
        if (defaultBreakpoint != null) {
            result2.add(defaultBreakpoint);
        }
        if ((breakpoints = this.myBreakpoints.get(type)) != null) {
            result2.addAll(breakpoints);
        }
        List list2 = Collections.unmodifiableList(result2);
        if (list2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    public <B extends XBreakpoint<?>> Collection<? extends B> getBreakpoints(@NotNull Class<? extends XBreakpointType<B, ?>> typeClass) {
        XBreakpointType type;
        if (typeClass == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(9);
        }
        LOG.assertTrue((type = XDebuggerUtil.getInstance().findBreakpointType(typeClass)) != null, (Object)("Unregistered breakpoint type " + typeClass + ", registered: " + Arrays.toString(XBreakpointType.EXTENSION_POINT_NAME.getExtensions())));
        Collection<B> collection = this.getBreakpoints(type);
        if (collection == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @Nullable
    public <B extends XBreakpoint<?>> B getDefaultBreakpoint(@NotNull XBreakpointType<B, ?> type) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(11);
        }
        return (B)this.myDefaultBreakpoints.get(type);
    }

    @Nullable
    public <P extends XBreakpointProperties> XLineBreakpoint<P> findBreakpointAtLine(@NotNull XLineBreakpointType<P> type, @NotNull VirtualFile file2, int line) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection breakpoints = this.myBreakpoints.get(type);
        if (breakpoints == null) {
            return null;
        }
        for (XBreakpointBase breakpoint : breakpoints) {
            XLineBreakpoint lineBreakpoint = (XLineBreakpoint)breakpoint;
            if (!lineBreakpoint.getFileUrl().equals(file2.getUrl()) || lineBreakpoint.getLine() != line) continue;
            return lineBreakpoint;
        }
        return null;
    }

    public boolean isDefaultBreakpoint(@NotNull XBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(14);
        }
        return this.myDefaultBreakpoints.values().contains(breakpoint);
    }

    private <T extends XBreakpointProperties> EventDispatcher<XBreakpointListener> getOrCreateDispatcher(XBreakpointType<?, T> type) {
        return this.myDispatchers.computeIfAbsent(type, k -> EventDispatcher.create(XBreakpointListener.class));
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void addBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener2) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(15);
        }
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(16);
        }
        this.getOrCreateDispatcher(type).addListener(listener2);
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void removeBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener2) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(17);
        }
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(18);
        }
        this.getOrCreateDispatcher(type).removeListener(listener2);
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void addBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener2, Disposable parentDisposable) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(19);
        }
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(20);
        }
        this.getOrCreateDispatcher(type).addListener(listener2, parentDisposable);
    }

    public void addBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener2) {
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(21);
        }
        this.myAllBreakpointsDispatcher.addListener(listener2);
    }

    public void removeBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener2) {
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(22);
        }
        this.myAllBreakpointsDispatcher.removeListener(listener2);
    }

    public void addBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(23);
        }
        if (parentDisposable == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(24);
        }
        this.myAllBreakpointsDispatcher.addListener(listener2, parentDisposable);
    }

    public void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> breakpoint, @Nullable Icon icon, @Nullable String errorMessage) {
        XLineBreakpointImpl lineBreakpoint;
        CustomizedBreakpointPresentation presentation;
        if (breakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(25);
        }
        if ((presentation = (lineBreakpoint = (XLineBreakpointImpl)breakpoint).getCustomizedPresentation()) == null) {
            if (icon == null && errorMessage == null) {
                return;
            }
            presentation = new CustomizedBreakpointPresentation();
        } else if (Comparing.equal((Object)presentation.getIcon(), (Object)icon) && Comparing.strEqual((String)presentation.getErrorMessage(), (String)errorMessage)) {
            return;
        }
        presentation.setErrorMessage(errorMessage);
        presentation.setIcon(icon);
        lineBreakpoint.setCustomizedPresentation(presentation);
        this.myLineBreakpointManager.queueBreakpointUpdate((XBreakpoint<?>)breakpoint);
    }

    public BreakpointManagerState getState() {
        this.myDependentBreakpointManager.saveState();
        BreakpointManagerState state2 = new BreakpointManagerState();
        for (XBreakpointBase<?, ?, ?> xBreakpointBase : this.myDefaultBreakpoints.values()) {
            Object breakpointState = xBreakpointBase.getState();
            if (!this.differsFromDefault((XBreakpointType)xBreakpointBase.getType(), (BreakpointState)breakpointState)) continue;
            state2.getDefaultBreakpoints().add((BreakpointState)breakpointState);
        }
        for (XBreakpointBase<Object, Object, Object> xBreakpointBase : this.myBreakpoints.values()) {
            state2.getBreakpoints().add((BreakpointState)xBreakpointBase.getState());
        }
        for (Map.Entry entry : this.myBreakpointsDefaults.entrySet()) {
            if (!XBreakpointManagerImpl.statesAreDifferent((BreakpointState)entry.getValue(), XBreakpointManagerImpl.createBreakpointDefaults((XBreakpointType)entry.getKey()))) continue;
            state2.getBreakpointsDefaults().add((BreakpointState)entry.getValue());
        }
        state2.setBreakpointsDialogProperties(this.myBreakpointsDialogSettings);
        state2.setTime(this.myTime);
        state2.setDefaultGroup(this.myDefaultGroup);
        return state2;
    }

    private <P extends XBreakpointProperties> boolean differsFromDefault(XBreakpointType<?, P> type, BreakpointState state2) {
        XBreakpoint<P> defaultBreakpoint = this.createDefaultBreakpoint(type);
        if (defaultBreakpoint == null) {
            return false;
        }
        Object defaultState = ((XBreakpointBase)defaultBreakpoint).getState();
        return XBreakpointManagerImpl.statesAreDifferent(state2, defaultState);
    }

    private static boolean statesAreDifferent(BreakpointState state1, BreakpointState state2) {
        Element elem2;
        Element elem1 = XmlSerializer.serialize((Object)state1, (SerializationFilter)SERIALIZATION_FILTER);
        return !JDOMUtil.areElementsEqual((Element)elem1, (Element)(elem2 = XmlSerializer.serialize((Object)state2, (SerializationFilter)SERIALIZATION_FILTER)));
    }

    public void loadState(@NotNull BreakpointManagerState state2) {
        if (state2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(26);
        }
        this.myBreakpointsDialogSettings = state2.getBreakpointsDialogProperties();
        this.myAllBreakpoints.clear();
        this.myDefaultBreakpoints.clear();
        this.myBreakpointsDefaults.clear();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (state2 == null) {
                XBreakpointManagerImpl.$$$reportNull$$$0(34);
            }
            state2.getDefaultBreakpoints().forEach(breakpointState -> this.loadBreakpoint((BreakpointState)breakpointState, true));
            ((StreamEx)XBreakpointUtil.breakpointTypes().remove(this.myDefaultBreakpoints::containsKey)).forEach(this::addDefaultBreakpoint);
            this.myBreakpoints.values().forEach(this::doRemoveBreakpoint);
            state2.getBreakpoints().forEach(breakpointState -> this.loadBreakpoint((BreakpointState)breakpointState, false));
            for (BreakpointState defaults : state2.getBreakpointsDefaults()) {
                XBreakpointType<?, ?> type = XBreakpointUtil.findType(defaults.getTypeId());
                if (type != null) {
                    this.myBreakpointsDefaults.put(type, defaults);
                    continue;
                }
                LOG.warn("Unknown breakpoint type " + defaults.getTypeId());
            }
            this.myDependentBreakpointManager.loadState();
        });
        this.myLineBreakpointManager.updateBreakpointsUI();
        this.myTime = state2.getTime();
        this.myDefaultGroup = state2.getDefaultGroup();
    }

    private <P extends XBreakpointProperties> void addDefaultBreakpoint(XBreakpointType<?, P> type) {
        XBreakpoint<P> breakpoint = this.createDefaultBreakpoint(type);
        if (breakpoint != null) {
            this.addBreakpoint((XBreakpointBase)breakpoint, true, false);
        }
    }

    @Nullable
    private <P extends XBreakpointProperties> XBreakpoint<P> createDefaultBreakpoint(XBreakpointType<? extends XBreakpoint<P>, P> type) {
        return type.createDefaultBreakpoint(properties -> this.createBreakpoint(type, properties, false, true));
    }

    private void loadBreakpoint(BreakpointState breakpointState, boolean defaultBreakpoint) {
        XBreakpointBase<?, ?, ?> breakpoint = this.createBreakpoint(breakpointState);
        if (breakpoint != null) {
            this.addBreakpoint(breakpoint, defaultBreakpoint, false);
        }
    }

    public XBreakpointsDialogState getBreakpointsDialogSettings() {
        return this.myBreakpointsDialogSettings;
    }

    public void setBreakpointsDialogSettings(XBreakpointsDialogState breakpointsDialogSettings) {
        this.myBreakpointsDialogSettings = breakpointsDialogSettings;
    }

    public Set<String> getAllGroups() {
        return StreamEx.of(this.myAllBreakpoints).map(XBreakpointBase::getGroup).nonNull().toSet();
    }

    public String getDefaultGroup() {
        return this.myDefaultGroup;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.myDefaultGroup = defaultGroup;
    }

    @Nullable
    private XBreakpointBase<?, ?, ?> createBreakpoint(BreakpointState breakpointState) {
        XBreakpointType<?, ?> type = XBreakpointUtil.findType(breakpointState.getTypeId());
        if (type == null) {
            LOG.warn("Unknown breakpoint type " + breakpointState.getTypeId());
            return null;
        }
        return breakpointState.createBreakpoint(type, this);
    }

    @NotNull
    public BreakpointState getBreakpointDefaults(@NotNull XBreakpointType type) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(27);
        }
        BreakpointState breakpointState = this.myBreakpointsDefaults.computeIfAbsent(type, k -> {
            if (type == null) {
                XBreakpointManagerImpl.$$$reportNull$$$0(33);
            }
            return XBreakpointManagerImpl.createBreakpointDefaults(type);
        });
        if (breakpointState == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(28);
        }
        return breakpointState;
    }

    @Nullable
    <T extends XBreakpointProperties> XLineBreakpoint<T> copyLineBreakpoint(@NotNull XLineBreakpoint<T> source, @NotNull String fileUrl, int line) {
        if (source == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(29);
        }
        if (fileUrl == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(30);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!(source instanceof XLineBreakpointImpl)) {
            return null;
        }
        this.myDependentBreakpointManager.saveState();
        LineBreakpointState sourceState = (LineBreakpointState)((XLineBreakpointImpl)source).getState();
        LineBreakpointState newState = (LineBreakpointState)XmlSerializer.deserialize((Element)XmlSerializer.serialize((Object)sourceState, (SerializationFilter)SERIALIZATION_FILTER), LineBreakpointState.class);
        newState.setLine(line);
        newState.setFileUrl(fileUrl);
        XLineBreakpointImpl breakpoint = (XLineBreakpointImpl)this.createBreakpoint(newState);
        if (breakpoint != null) {
            this.addBreakpoint(breakpoint, false, true);
            XBreakpoint<?> masterBreakpoint = this.myDependentBreakpointManager.getMasterBreakpoint((XBreakpoint<?>)source);
            if (masterBreakpoint != null) {
                this.myDependentBreakpointManager.setMasterBreakpoint(breakpoint, masterBreakpoint, sourceState.getDependencyState().isLeaveEnabled());
            }
        }
        return breakpoint;
    }

    @NotNull
    private static BreakpointState createBreakpointDefaults(@NotNull XBreakpointType type) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(31);
        }
        BreakpointState state2 = new BreakpointState();
        state2.setTypeId(type.getId());
        state2.setSuspendPolicy(type.getDefaultSuspendPolicy());
        BreakpointState breakpointState = state2;
        if (breakpointState == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(32);
        }
        return breakpointState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl";
                break;
            }
            case 1: 
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 2: 
            case 4: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 27: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "addBreakpoint";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addLineBreakpoint";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBreakpoints";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpoints";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointDefaults";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createBreakpointDefaults";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpoint";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addLineBreakpoint";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBreakpoints";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultBreakpoint";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findBreakpointAtLine";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultBreakpoint";
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpointListener";
                break;
            }
            case 17: 
            case 18: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpointListener";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "updateBreakpointPresentation";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getBreakpointDefaults";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "copyLineBreakpoint";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointDefaults";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getBreakpointDefaults$6";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadState$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="breakpoint-manager")
    public static class BreakpointManagerState {
        private List<BreakpointState> myDefaultBreakpoints = new ArrayList<BreakpointState>();
        private List<BreakpointState> myBreakpoints = new ArrayList<BreakpointState>();
        private List<BreakpointState> myBreakpointsDefaults = new ArrayList<BreakpointState>();
        private XBreakpointsDialogState myBreakpointsDialogProperties;
        private long myTime;
        private String myDefaultGroup;

        @Tag(value="default-breakpoints")
        @AbstractCollection(surroundWithTag=false)
        public List<BreakpointState> getDefaultBreakpoints() {
            return this.myDefaultBreakpoints;
        }

        @Tag(value="breakpoints")
        @AbstractCollection(surroundWithTag=false, elementTypes={BreakpointState.class, LineBreakpointState.class})
        public List<BreakpointState> getBreakpoints() {
            return this.myBreakpoints;
        }

        @Tag(value="breakpoints-defaults")
        @AbstractCollection(surroundWithTag=false, elementTypes={BreakpointState.class, LineBreakpointState.class})
        public List<BreakpointState> getBreakpointsDefaults() {
            return this.myBreakpointsDefaults;
        }

        @Tag(value="breakpoints-dialog")
        public XBreakpointsDialogState getBreakpointsDialogProperties() {
            return this.myBreakpointsDialogProperties;
        }

        public void setBreakpoints(List<BreakpointState> breakpoints) {
            this.myBreakpoints = breakpoints;
        }

        public void setDefaultBreakpoints(List<BreakpointState> defaultBreakpoints) {
            this.myDefaultBreakpoints = defaultBreakpoints;
        }

        public void setBreakpointsDefaults(List<BreakpointState> breakpointsDefaults) {
            this.myBreakpointsDefaults = breakpointsDefaults;
        }

        public void setBreakpointsDialogProperties(XBreakpointsDialogState breakpointsDialogProperties) {
            this.myBreakpointsDialogProperties = breakpointsDialogProperties;
        }

        public long getTime() {
            return this.myTime;
        }

        public void setTime(long time) {
            this.myTime = time;
        }

        public String getDefaultGroup() {
            return this.myDefaultGroup;
        }

        public void setDefaultGroup(String defaultGroup) {
            this.myDefaultGroup = defaultGroup;
        }
    }
}

