/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointDependencyState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointListener;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDependentBreakpointManager {
    private final Map<XBreakpoint<?>, XDependentBreakpointInfo> mySlave2Info = new HashMap();
    private final MultiValuesMap<XBreakpointBase, XDependentBreakpointInfo> myMaster2Info = new MultiValuesMap();
    private final XBreakpointManagerImpl myBreakpointManager;
    private final EventDispatcher<XDependentBreakpointListener> myDispatcher;

    public XDependentBreakpointManager(XBreakpointManagerImpl breakpointManager) {
        this.myBreakpointManager = breakpointManager;
        this.myDispatcher = EventDispatcher.create(XDependentBreakpointListener.class);
        this.myBreakpointManager.addBreakpointListener(new XBreakpointListener<XBreakpoint<?>>(){

            public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
                Collection infos;
                XDependentBreakpointInfo info;
                if (breakpoint == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((info = (XDependentBreakpointInfo)XDependentBreakpointManager.this.mySlave2Info.remove(breakpoint)) != null) {
                    XDependentBreakpointManager.this.myMaster2Info.remove((Object)info.myMasterBreakpoint, (Object)info);
                }
                if ((infos = XDependentBreakpointManager.this.myMaster2Info.removeAll((Object)((XBreakpointBase)breakpoint))) != null) {
                    for (XDependentBreakpointInfo breakpointInfo : infos) {
                        XDependentBreakpointInfo removed = (XDependentBreakpointInfo)XDependentBreakpointManager.this.mySlave2Info.remove(breakpointInfo.mySlaveBreakpoint);
                        if (removed == null) continue;
                        ((XDependentBreakpointListener)XDependentBreakpointManager.this.myDispatcher.getMulticaster()).dependencyCleared(breakpointInfo.mySlaveBreakpoint);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManager$1", "breakpointRemoved"));
            }
        });
    }

    public void addListener(XDependentBreakpointListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void removeListener(XDependentBreakpointListener listener2) {
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void loadState() {
        XBreakpointDependencyState state2;
        this.mySlave2Info.clear();
        this.myMaster2Info.clear();
        HashMap id2Breakpoint = new HashMap();
        for (XBreakpointBase<?, ?, ?> breakpoint : this.myBreakpointManager.getAllBreakpoints()) {
            String id;
            state2 = breakpoint.getDependencyState();
            if (state2 == null || (id = state2.getId()) == null) continue;
            id2Breakpoint.put(id, breakpoint);
        }
        for (XBreakpointBase<?, ?, ?> breakpoint : this.myBreakpointManager.getAllBreakpoints()) {
            XBreakpointBase master;
            String masterId;
            state2 = breakpoint.getDependencyState();
            if (state2 == null || (masterId = state2.getMasterBreakpointId()) == null || (master = (XBreakpointBase)id2Breakpoint.get(masterId)) == null) continue;
            this.addDependency(master, breakpoint, state2.isLeaveEnabled());
        }
    }

    public void saveState() {
        HashMap<XBreakpointBase, String> breakpoint2Id = new HashMap<XBreakpointBase, String>();
        int id = 0;
        for (XBreakpointBase xBreakpointBase : this.myMaster2Info.keySet()) {
            breakpoint2Id.put(xBreakpointBase, String.valueOf(id++));
        }
        for (XDependentBreakpointInfo xDependentBreakpointInfo : this.mySlave2Info.values()) {
            XBreakpointDependencyState state2 = new XBreakpointDependencyState((String)breakpoint2Id.get(xDependentBreakpointInfo.mySlaveBreakpoint), (String)breakpoint2Id.get(xDependentBreakpointInfo.myMasterBreakpoint), xDependentBreakpointInfo.myLeaveEnabled);
            xDependentBreakpointInfo.mySlaveBreakpoint.setDependencyState(state2);
        }
        for (Map.Entry entry : breakpoint2Id.entrySet()) {
            if (this.mySlave2Info.containsKey(entry.getKey())) continue;
            ((XBreakpointBase)entry.getKey()).setDependencyState(new XBreakpointDependencyState((String)entry.getValue()));
        }
    }

    public void setMasterBreakpoint(@NotNull XBreakpoint<?> slave, @NotNull XBreakpoint<?> master, boolean leaveEnabled) {
        XDependentBreakpointInfo info;
        if (slave == null) {
            XDependentBreakpointManager.$$$reportNull$$$0(0);
        }
        if (master == null) {
            XDependentBreakpointManager.$$$reportNull$$$0(1);
        }
        if ((info = this.mySlave2Info.get(slave)) == null) {
            this.addDependency((XBreakpointBase)master, (XBreakpointBase)slave, leaveEnabled);
        } else if (info.myMasterBreakpoint == master) {
            info.myLeaveEnabled = leaveEnabled;
        } else {
            this.myMaster2Info.remove((Object)info.myMasterBreakpoint, (Object)info);
            info.myMasterBreakpoint = (XBreakpointBase)master;
            info.myLeaveEnabled = leaveEnabled;
            this.myMaster2Info.put((Object)((XBreakpointBase)master), (Object)info);
        }
        ((XDependentBreakpointListener)this.myDispatcher.getMulticaster()).dependencySet(slave, master);
    }

    public void clearMasterBreakpoint(@NotNull XBreakpoint<?> slave) {
        XDependentBreakpointInfo info;
        if (slave == null) {
            XDependentBreakpointManager.$$$reportNull$$$0(2);
        }
        if ((info = this.mySlave2Info.remove(slave)) != null) {
            this.myMaster2Info.remove((Object)info.myMasterBreakpoint, (Object)info);
            ((XDependentBreakpointListener)this.myDispatcher.getMulticaster()).dependencyCleared(slave);
        }
    }

    private void addDependency(XBreakpointBase<?, ?, ?> master, XBreakpointBase<?, ?, ?> slave, boolean leaveEnabled) {
        XDependentBreakpointInfo info = new XDependentBreakpointInfo(master, slave, leaveEnabled);
        this.mySlave2Info.put(slave, info);
        this.myMaster2Info.put(master, (Object)info);
    }

    @Nullable
    public XBreakpoint<?> getMasterBreakpoint(@NotNull XBreakpoint<?> slave) {
        XDependentBreakpointInfo info;
        if (slave == null) {
            XDependentBreakpointManager.$$$reportNull$$$0(3);
        }
        return (info = this.mySlave2Info.get(slave)) != null ? info.myMasterBreakpoint : null;
    }

    public boolean isLeaveEnabled(@NotNull XBreakpoint<?> slave) {
        XDependentBreakpointInfo info;
        if (slave == null) {
            XDependentBreakpointManager.$$$reportNull$$$0(4);
        }
        return (info = this.mySlave2Info.get(slave)) != null && info.myLeaveEnabled;
    }

    public List<XBreakpoint<?>> getSlaveBreakpoints(XBreakpoint<?> breakpoint) {
        Collection slaveInfos = this.myMaster2Info.get((Object)((XBreakpointBase)breakpoint));
        if (slaveInfos == null) {
            return Collections.emptyList();
        }
        SmartList breakpoints = new SmartList();
        for (XDependentBreakpointInfo slaveInfo : slaveInfos) {
            breakpoints.add(slaveInfo.mySlaveBreakpoint);
        }
        return breakpoints;
    }

    public boolean isMasterOrSlave(XBreakpoint<?> breakpoint) {
        return this.myMaster2Info.containsKey((Object)((XBreakpointBase)breakpoint)) || this.mySlave2Info.containsKey(breakpoint);
    }

    public Set<XBreakpoint<?>> getAllSlaveBreakpoints() {
        return this.mySlave2Info.keySet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slave";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "master";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setMasterBreakpoint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "clearMasterBreakpoint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getMasterBreakpoint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isLeaveEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class XDependentBreakpointInfo {
        private XBreakpointBase myMasterBreakpoint;
        private final XBreakpointBase mySlaveBreakpoint;
        private boolean myLeaveEnabled;

        private XDependentBreakpointInfo(@NotNull XBreakpointBase masterBreakpoint, XBreakpointBase slaveBreakpoint, boolean leaveEnabled) {
            if (masterBreakpoint == null) {
                XDependentBreakpointInfo.$$$reportNull$$$0(0);
            }
            this.myMasterBreakpoint = masterBreakpoint;
            this.myLeaveEnabled = leaveEnabled;
            this.mySlaveBreakpoint = slaveBreakpoint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "masterBreakpoint", "com/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManager$XDependentBreakpointInfo", "<init>"));
        }
    }
}

