/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.google.common.collect.Lists;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.python.HelperPackage;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum PythonHelper implements HelperPackage
{
    GENERATOR3("generator3.py"),
    COVERAGEPY("coveragepy", ""),
    COVERAGE("coverage_runner", "run_coverage"),
    DEBUGGER("pydev", "pydevd"),
    ATTACH_DEBUGGER("pydev/pydevd_attach_to_process/attach_pydevd.py"),
    CONSOLE("pydev", "pydevconsole"),
    RUN_IN_CONSOLE("pydev", "pydev_run_in_console"),
    PROFILER("profiler", "run_profiler"),
    LOAD_ENTRY_POINT("pycharm", "pycharm_load_entry_point"),
    UT_OLD("pycharm", "utrunner"),
    TOX("pycharm", "_jb_tox_runner"),
    SETUPPY("pycharm", "pycharm_setup_runner"),
    NOSE_OLD("pycharm", "noserunner"),
    PYTEST_OLD("pycharm", "pytestrunner"),
    DOCSTRING("pycharm", "docrunner"),
    UNITTEST("pycharm", "_jb_unittest_runner"),
    PYTEST("pycharm", "_jb_pytest_runner"),
    TRIAL("pycharm", "_jb_trialtest_runner"),
    NOSE("pycharm", "_jb_nosetest_runner"),
    BEHAVE("pycharm", "behave_runner"),
    LETTUCE("pycharm", "lettuce_runner"),
    DJANGO_TEST_MANAGE("pycharm", "django_test_manage"),
    DJANGO_MANAGE("pycharm", "django_manage"),
    MANAGE_TASKS_PROVIDER("pycharm", "_jb_manage_tasks_provider"),
    APPCFG_CONSOLE("pycharm", "appcfg_fetcher"),
    BUILDOUT_ENGULFER("pycharm", "buildout_engulfer"),
    DOCSTRING_FORMATTER("docstring_formatter.py"),
    EXTRA_SYSPATH("extra_syspath.py"),
    SYSPATH("syspath.py"),
    PYCODESTYLE("pycodestyle.py"),
    REST_RUNNER("rest_runners/rst2smth.py"),
    SPHINX_RUNNER("rest_runners/sphinx_runner.py");

    public static final String PY3_HELPER_DEPENDENCIES_DIR = "py3only";
    public static final String PY2_HELPER_DEPENDENCIES_DIR = "py2only";
    private final PathHelperPackage myModule;

    @NotNull
    private static PathHelperPackage findModule(String moduleEntryPoint, String path, boolean asModule) {
        if (PythonHelpersLocator.getHelperFile(path + ".zip").isFile()) {
            ModuleHelperPackage moduleHelperPackage = new ModuleHelperPackage(moduleEntryPoint, path + ".zip");
            if (moduleHelperPackage == null) {
                PythonHelper.$$$reportNull$$$0(0);
            }
            return moduleHelperPackage;
        }
        if (!asModule && new File(PythonHelpersLocator.getHelperFile(path), moduleEntryPoint + ".py").isFile()) {
            ScriptPythonHelper scriptPythonHelper = new ScriptPythonHelper(moduleEntryPoint + ".py", PythonHelpersLocator.getHelperFile(path));
            if (scriptPythonHelper == null) {
                PythonHelper.$$$reportNull$$$0(1);
            }
            return scriptPythonHelper;
        }
        ModuleHelperPackage moduleHelperPackage = new ModuleHelperPackage(moduleEntryPoint, path);
        if (moduleHelperPackage == null) {
            PythonHelper.$$$reportNull$$$0(2);
        }
        return moduleHelperPackage;
    }

    private PythonHelper(String pythonPath, String moduleName) {
        this(pythonPath, moduleName, false);
    }

    private PythonHelper(String pythonPath, String moduleName, boolean asModule) {
        this.myModule = PythonHelper.findModule(moduleName, pythonPath, asModule);
    }

    private PythonHelper(String helperScript) {
        this.myModule = new ScriptPythonHelper(helperScript, PythonHelpersLocator.getHelpersRoot());
    }

    @Override
    @NotNull
    public String getPythonPathEntry() {
        String string = this.myModule.getPythonPathEntry();
        if (string == null) {
            PythonHelper.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public void addToPythonPath(@NotNull Map<String, String> environment) {
        if (environment == null) {
            PythonHelper.$$$reportNull$$$0(4);
        }
        this.myModule.addToPythonPath(environment);
    }

    @Override
    public void addToGroup(@NotNull ParamsGroup group, @NotNull GeneralCommandLine cmd) {
        if (group == null) {
            PythonHelper.$$$reportNull$$$0(5);
        }
        if (cmd == null) {
            PythonHelper.$$$reportNull$$$0(6);
        }
        this.myModule.addToGroup(group, cmd);
    }

    @Override
    @NotNull
    public String asParamString() {
        String string = this.myModule.asParamString();
        if (string == null) {
            PythonHelper.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public GeneralCommandLine newCommandLine(@NotNull String sdkPath, @NotNull List<String> parameters) {
        if (sdkPath == null) {
            PythonHelper.$$$reportNull$$$0(8);
        }
        if (parameters == null) {
            PythonHelper.$$$reportNull$$$0(9);
        }
        GeneralCommandLine generalCommandLine = this.myModule.newCommandLine(sdkPath, parameters);
        if (generalCommandLine == null) {
            PythonHelper.$$$reportNull$$$0(10);
        }
        return generalCommandLine;
    }

    @Override
    @NotNull
    public GeneralCommandLine newCommandLine(@NotNull Sdk pythonSdk, @NotNull List<String> parameters) {
        if (pythonSdk == null) {
            PythonHelper.$$$reportNull$$$0(11);
        }
        if (parameters == null) {
            PythonHelper.$$$reportNull$$$0(12);
        }
        GeneralCommandLine generalCommandLine = this.myModule.newCommandLine(pythonSdk, parameters);
        if (generalCommandLine == null) {
            PythonHelper.$$$reportNull$$$0(13);
        }
        return generalCommandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PythonHelper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonPathEntry";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PythonHelper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "asParamString";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "newCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addToPythonPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addToGroup";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "newCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ScriptPythonHelper
    extends PathHelperPackage {
        private final String myPythonPath;

        public ScriptPythonHelper(String script, File pythonPath) {
            super(new File(pythonPath, script).getAbsolutePath());
            this.myPythonPath = pythonPath.getAbsolutePath();
        }

        @Override
        public void addToPythonPath(@NotNull Map<String, String> environment) {
            if (environment == null) {
                ScriptPythonHelper.$$$reportNull$$$0(0);
            }
            PythonEnvUtil.setPythonDontWriteBytecode(environment);
            super.addToPythonPath(environment);
        }

        @Override
        @NotNull
        public String getPythonPathEntry() {
            String string = this.myPythonPath;
            if (string == null) {
                ScriptPythonHelper.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/PythonHelper$ScriptPythonHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/PythonHelper$ScriptPythonHelper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPythonPathEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addToPythonPath";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ModuleHelperPackage
    extends PathHelperPackage {
        private final String myModuleName;

        public ModuleHelperPackage(String moduleName, String relativePath) {
            super(PythonHelpersLocator.getHelperFile(relativePath).getAbsolutePath());
            this.myModuleName = moduleName;
        }

        @Override
        @NotNull
        public String asParamString() {
            String string = "-m" + this.myModuleName;
            if (string == null) {
                ModuleHelperPackage.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getPythonPathEntry() {
            String string = FileUtil.toSystemDependentName((String)this.myPath.getAbsolutePath());
            if (string == null) {
                ModuleHelperPackage.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/python/PythonHelper$ModuleHelperPackage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asParamString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPythonPathEntry";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static abstract class PathHelperPackage
    implements HelperPackage {
        protected final File myPath;

        PathHelperPackage(String path) {
            this.myPath = new File(path);
        }

        @Override
        public void addToPythonPath(@NotNull Map<String, String> environment) {
            if (environment == null) {
                PathHelperPackage.$$$reportNull$$$0(0);
            }
            PythonEnvUtil.addToPythonPath(environment, this.getPythonPathEntry());
        }

        @Override
        public void addToGroup(@NotNull ParamsGroup group, @NotNull GeneralCommandLine cmd) {
            if (group == null) {
                PathHelperPackage.$$$reportNull$$$0(1);
            }
            if (cmd == null) {
                PathHelperPackage.$$$reportNull$$$0(2);
            }
            this.addToPythonPath(cmd.getEnvironment());
            group.addParameter(this.asParamString());
        }

        @Override
        @NotNull
        public String asParamString() {
            String string = FileUtil.toSystemDependentName((String)this.myPath.getAbsolutePath());
            if (string == null) {
                PathHelperPackage.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public GeneralCommandLine newCommandLine(@NotNull String sdkPath, @NotNull List<String> parameters) {
            if (sdkPath == null) {
                PathHelperPackage.$$$reportNull$$$0(4);
            }
            if (parameters == null) {
                PathHelperPackage.$$$reportNull$$$0(5);
            }
            ArrayList args = Lists.newArrayList();
            args.add(sdkPath);
            args.add(this.asParamString());
            args.addAll(parameters);
            GeneralCommandLine cmd = new GeneralCommandLine((List)args);
            Map env = cmd.getEnvironment();
            this.addToPythonPath(env);
            PythonEnvUtil.resetHomePathChanges(sdkPath, env);
            GeneralCommandLine generalCommandLine = cmd;
            if (generalCommandLine == null) {
                PathHelperPackage.$$$reportNull$$$0(6);
            }
            return generalCommandLine;
        }

        @Override
        @NotNull
        public GeneralCommandLine newCommandLine(@NotNull Sdk pythonSdk, @NotNull List<String> parameters) {
            if (pythonSdk == null) {
                PathHelperPackage.$$$reportNull$$$0(7);
            }
            if (parameters == null) {
                PathHelperPackage.$$$reportNull$$$0(8);
            }
            String sdkHomePath = pythonSdk.getHomePath();
            assert (sdkHomePath != null);
            GeneralCommandLine cmd = this.newCommandLine(sdkHomePath, parameters);
            LanguageLevel version = PythonSdkType.getLanguageLevelForSdk(pythonSdk);
            String perVersionDependenciesDir = version.isPython2() ? PythonHelper.PY2_HELPER_DEPENDENCIES_DIR : PythonHelper.PY3_HELPER_DEPENDENCIES_DIR;
            PythonEnvUtil.addToPythonPath((Map<String, String>)cmd.getEnvironment(), FileUtil.join((String[])new String[]{this.getPythonPathEntry(), perVersionDependenciesDir}));
            GeneralCommandLine generalCommandLine = cmd;
            if (generalCommandLine == null) {
                PathHelperPackage.$$$reportNull$$$0(9);
            }
            return generalCommandLine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cmd";
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/PythonHelper$PathHelperPackage";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkPath";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pythonSdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/PythonHelper$PathHelperPackage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asParamString";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newCommandLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addToPythonPath";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addToGroup";
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "newCommandLine";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

