/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.images.editor.impl.ImageFileEditorImpl;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class ImageFileEditorProvider
implements FileEditorProvider,
DumbAware {
    @NonNls
    private static final String EDITOR_TYPE_ID = "images";
    private final ImageFileTypeManager typeManager;

    ImageFileEditorProvider(ImageFileTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            ImageFileEditorProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ImageFileEditorProvider.$$$reportNull$$$0(1);
        }
        return this.typeManager.isImage(file2);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            ImageFileEditorProvider.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ImageFileEditorProvider.$$$reportNull$$$0(3);
        }
        ImageFileEditorImpl viewer = new ImageFileEditorImpl(project, file2);
        if ("svg".equalsIgnoreCase(file2.getExtension())) {
            TextEditorWithPreview textEditorWithPreview = new TextEditorWithPreview((TextEditor)TextEditorProvider.getInstance().createEditor(project, file2), viewer);
            if (textEditorWithPreview == null) {
                ImageFileEditorProvider.$$$reportNull$$$0(4);
            }
            return textEditorWithPreview;
        }
        ImageFileEditorImpl imageFileEditorImpl = viewer;
        if (imageFileEditorImpl == null) {
            ImageFileEditorProvider.$$$reportNull$$$0(5);
        }
        return imageFileEditorImpl;
    }

    @NotNull
    public String getEditorTypeId() {
        if (EDITOR_TYPE_ID == null) {
            ImageFileEditorProvider.$$$reportNull$$$0(6);
        }
        return EDITOR_TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            ImageFileEditorProvider.$$$reportNull$$$0(7);
        }
        return fileEditorPolicy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/images/editor/impl/ImageFileEditorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/images/editor/impl/ImageFileEditorProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorTypeId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

