/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.browse;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.browse.BrowseClient;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.jetbrains.idea.svn.checkin.CmdCheckinClient;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.lock.Lock;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdBrowseClient
extends BaseSvnClient
implements BrowseClient {
    @Override
    public void list(@NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable Depth depth, @Nullable DirectoryEntryConsumer handler) throws VcsException {
        if (target == null) {
            CmdBrowseClient.$$$reportNull$$$0(0);
        }
        this.assertUrl(target);
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, depth);
        parameters.add("--xml");
        CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.list, parameters, null);
        Info info = this.myFactory.createInfoClient().doInfo(target, revision);
        try {
            CmdBrowseClient.parseOutput(target.getURL(), command, handler, info != null ? info.getRepositoryRootURL() : null);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public long createDirectory(@NotNull SvnTarget target, @NotNull String message, boolean makeParents) throws VcsException {
        if (target == null) {
            CmdBrowseClient.$$$reportNull$$$0(1);
        }
        if (message == null) {
            CmdBrowseClient.$$$reportNull$$$0(2);
        }
        this.assertUrl(target);
        ArrayList parameters = ContainerUtil.newArrayList();
        CommandUtil.put((List<String>)parameters, target);
        CommandUtil.put((List<String>)parameters, makeParents, "--parents");
        parameters.add("--message");
        parameters.add(message);
        CmdCheckinClient.CommandListener listener = new CmdCheckinClient.CommandListener(null);
        this.execute(this.myVcs, target, SvnCommandName.mkdir, parameters, (LineCommandListener)listener);
        return listener.getCommittedRevision();
    }

    private static void parseOutput(@NotNull SVNURL url, @NotNull CommandExecutor command, @Nullable DirectoryEntryConsumer handler, @Nullable SVNURL repositoryUrl) throws VcsException, SVNException {
        if (url == null) {
            CmdBrowseClient.$$$reportNull$$$0(3);
        }
        if (command == null) {
            CmdBrowseClient.$$$reportNull$$$0(4);
        }
        try {
            TargetLists lists = CommandUtil.parse(command.getOutput(), TargetLists.class);
            if (handler != null && lists != null) {
                for (TargetList list : lists.lists) {
                    for (Entry entry : list.entries) {
                        handler.consume(entry.toDirectoryEntry(url, repositoryUrl));
                    }
                }
            }
        }
        catch (JAXBException e) {
            throw new SvnBindException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/browse/CmdBrowseClient";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "list";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createDirectory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseOutput";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Entry {
        @XmlAttribute(name="kind", required=true)
        public NodeKind kind;
        @XmlElement(name="name")
        public String name;
        @XmlElement(name="size")
        public long size;
        public CommitInfo.Builder commit;
        public Lock.Builder lock;

        @NotNull
        public DirectoryEntry toDirectoryEntry(@NotNull SVNURL url, @Nullable SVNURL repositoryUrl) throws SVNException {
            if (url == null) {
                Entry.$$$reportNull$$$0(0);
            }
            DirectoryEntry directoryEntry = new DirectoryEntry(url.appendPath(this.name, false), repositoryUrl, PathUtil.getFileName((String)this.name), this.kind, this.commit != null ? this.commit.build() : null, this.name);
            if (directoryEntry == null) {
                Entry.$$$reportNull$$$0(1);
            }
            return directoryEntry;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/browse/CmdBrowseClient$Entry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/browse/CmdBrowseClient$Entry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toDirectoryEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "toDirectoryEntry";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TargetList {
        @XmlAttribute(name="path")
        public String path;
        @XmlElement(name="entry")
        public List<Entry> entries = new ArrayList<Entry>();
    }

    @XmlRootElement(name="lists")
    public static class TargetLists {
        @XmlElement(name="list")
        public List<TargetList> lists = new ArrayList<TargetList>();
    }
}

