/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.networking;

import com.intellij.openapi.util.text.StringUtil;
import java.lang.reflect.Field;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SSLProtocolExceptionParser {
    private final String myMessage;
    private String myParsedMessage;
    private byte myFieldValue;
    private String myFieldName;

    public SSLProtocolExceptionParser(@NotNull String message) {
        if (message == null) {
            SSLProtocolExceptionParser.$$$reportNull$$$0(0);
        }
        this.myMessage = message;
    }

    public void parse() {
        String[] possiblePlaces;
        this.myParsedMessage = this.myMessage;
        this.myFieldValue = 0;
        this.myFieldName = null;
        List words = StringUtil.split((String)this.myMessage.trim(), (String)" ");
        if (words.isEmpty()) {
            return;
        }
        for (String place : possiblePlaces = new String[]{"com.sun.net.ssl.internal.ssl.Alerts", "sun.security.ssl.Alerts"}) {
            try {
                Class<?> clazz = Class.forName(place);
                if (!this.tryByStaticField(clazz, (String)words.get(words.size() - 1))) continue;
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public String getParsedMessage() {
        return this.myParsedMessage;
    }

    private boolean tryByStaticField(Class<?> clazz, String word) {
        try {
            Field field = clazz.getDeclaredField("alert_" + word);
            field.setAccessible(true);
            this.myFieldValue = field.getByte(clazz);
            this.myFieldName = field.getName();
            this.myParsedMessage = "SSLProtocolException: alert code: " + Byte.toString(this.myFieldValue) + " alert name: " + this.myFieldName + ", original message: " + this.myMessage;
            if ("alert_unrecognized_name".equals(this.myFieldName)) {
                this.myParsedMessage = this.myParsedMessage + "\nThis may be JDK bug 7127374 : JSSE creates SSLProtocolException on (common) warning: unrecognized_name for SNI";
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/svn/networking/SSLProtocolExceptionParser", "<init>"));
    }
}

