/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgErrorHandler;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgPromptCommandExecutor;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgMergeCommand {
    @NotNull
    private final Project project;
    @NotNull
    private final HgRepository repo;
    @Nullable
    private String revision;

    public HgMergeCommand(@NotNull Project project, @NotNull HgRepository repo) {
        if (project == null) {
            HgMergeCommand.$$$reportNull$$$0(0);
        }
        if (repo == null) {
            HgMergeCommand.$$$reportNull$$$0(1);
        }
        this.project = project;
        this.repo = repo;
    }

    private void setRevision(@NotNull String revision) {
        if (revision == null) {
            HgMergeCommand.$$$reportNull$$$0(2);
        }
        this.revision = revision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private HgCommandResult executeInCurrentThread() {
        HgPromptCommandExecutor commandExecutor = new HgPromptCommandExecutor(this.project);
        commandExecutor.setShowOutput(true);
        LinkedList<String> arguments = new LinkedList<String>();
        if (!StringUtil.isEmptyOrSpaces((String)this.revision)) {
            arguments.add("--rev");
            arguments.add(this.revision);
        }
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.project);
        try {
            HgCommandResult result = commandExecutor.executeInCurrentThread(this.repo.getRoot(), "merge", arguments);
            this.repo.update();
            HgCommandResult hgCommandResult = result;
            return hgCommandResult;
        }
        finally {
            token.finish();
        }
    }

    @Nullable
    public HgCommandResult mergeSynchronously() throws VcsException {
        HgCommandResult commandResult = HgErrorHandler.ensureSuccess(this.executeInCurrentThread());
        HgUtil.markDirectoryDirty(this.project, this.repo.getRoot());
        return commandResult;
    }

    public static void mergeWith(@NotNull HgRepository repository, @NotNull String branchName, @NotNull UpdatedFiles updatedFiles) {
        if (repository == null) {
            HgMergeCommand.$$$reportNull$$$0(3);
        }
        if (branchName == null) {
            HgMergeCommand.$$$reportNull$$$0(4);
        }
        if (updatedFiles == null) {
            HgMergeCommand.$$$reportNull$$$0(5);
        }
        HgMergeCommand.mergeWith(repository, branchName, updatedFiles, null);
    }

    public static void mergeWith(@NotNull HgRepository repository, @NotNull String branchName, final @NotNull UpdatedFiles updatedFiles, final @Nullable Runnable onSuccessHandler) {
        if (repository == null) {
            HgMergeCommand.$$$reportNull$$$0(6);
        }
        if (branchName == null) {
            HgMergeCommand.$$$reportNull$$$0(7);
        }
        if (updatedFiles == null) {
            HgMergeCommand.$$$reportNull$$$0(8);
        }
        final Project project = repository.getProject();
        final VirtualFile repositoryRoot = repository.getRoot();
        final HgMergeCommand hgMergeCommand = new HgMergeCommand(project, repository);
        hgMergeCommand.setRevision(branchName);
        new Task.Backgroundable(project, "Merging Changes..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    HgCommandResult result = hgMergeCommand.mergeSynchronously();
                    if (HgErrorUtil.isAncestorMergeError(result)) {
                        VcsNotifier.getInstance((Project)project).notifyMinorWarning("Merging is skipped for " + repositoryRoot.getPresentableName(), "Merging with a working directory ancestor has no effect");
                        return;
                    }
                    new HgConflictResolver(project, updatedFiles).resolve(repositoryRoot);
                    if (!HgConflictResolver.hasConflicts(project, repositoryRoot) && onSuccessHandler != null) {
                        onSuccessHandler.run();
                    }
                }
                catch (VcsException exception) {
                    if (exception.isWarning()) {
                        VcsNotifier.getInstance((Project)project).notifyWarning("Warning during merge", exception.getMessage());
                    }
                    VcsNotifier.getInstance((Project)project).notifyError("Exception during merge", exception.getMessage());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/command/HgMergeCommand$1", "run"));
            }
        }.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedFiles";
                break;
            }
        }
        objectArray2[1] = "org/zmlx/hg4idea/command/HgMergeCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setRevision";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "mergeWith";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

