/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicLong;

public class IdeaForkJoinWorkerThreadFactory
implements ForkJoinPool.ForkJoinWorkerThreadFactory {
    private static final AtomicLong bits = new AtomicLong();

    public static void setupForkJoinCommonPool() {
        System.setProperty("java.util.concurrent.ForkJoinPool.common.threadFactory", IdeaForkJoinWorkerThreadFactory.class.getName());
    }

    @Override
    public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        final int n = IdeaForkJoinWorkerThreadFactory.setNextBit();
        ForkJoinWorkerThread thread = new ForkJoinWorkerThread(pool){

            @Override
            protected void onTermination(Throwable exception) {
                IdeaForkJoinWorkerThreadFactory.clearBit(n);
                super.onTermination(exception);
            }
        };
        thread.setName("JobScheduler FJ pool " + n + "/" + pool.getParallelism());
        thread.setPriority(4);
        return thread;
    }

    private static int setNextBit() {
        long oldValue = bits.getAndUpdate(value -> value + 1L | value);
        return Long.numberOfTrailingZeros(oldValue + 1L);
    }

    private static void clearBit(int n) {
        bits.updateAndGet(value -> value & (1L << n ^ 0xFFFFFFFFFFFFFFFFL));
    }
}

