/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.actions.ActionOnSelectedElement;
import com.intellij.cvsSupport2.actions.actionVisibility.CvsActionVisibility;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextWrapper;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.cvsoperations.cvsCheckOut.ui.CheckoutFileDialog;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.ui.ReplaceFileConfirmationDialog;
import com.intellij.util.ui.OptionsDialog;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class CheckoutFileAction
extends ActionOnSelectedElement {
    private Collection myModifiedFiles;

    public CheckoutFileAction() {
        super(true);
        CvsActionVisibility visibility = this.getVisibility();
        visibility.canBePerformedOnSeveralFiles();
        visibility.canBePerformedOnLocallyDeletedFile();
        visibility.addCondition(FILES_EXIST_IN_CVS);
    }

    @Override
    protected String getTitle(VcsContext context) {
        return CvsBundle.getCheckoutOperationName();
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        if (!e.getPresentation().isVisible()) {
            return;
        }
        Project project = CvsContextWrapper.createInstance(e).getProject();
        if (project == null) {
            return;
        }
        CheckoutFileAction.adjustName(CvsVcs2.getInstance(project).getCheckoutOptions().getValue(), e);
    }

    @Override
    protected CvsHandler getCvsHandler(CvsContext context) {
        CheckoutFileDialog checkoutFileDialog;
        if (this.myModifiedFiles != null && !this.myModifiedFiles.isEmpty() && !new ReplaceFileConfirmationDialog(context.getProject(), CvsBundle.getCheckoutOperationName()).requestConfirmation(this.myModifiedFiles)) {
            return CvsHandler.NULL;
        }
        this.myModifiedFiles = null;
        Project project = context.getProject();
        FilePath[] filesArray = context.getSelectedFilePaths();
        List<FilePath> files = Arrays.asList(filesArray);
        if ((CvsVcs2.getInstance(project).getCheckoutOptions().getValue() || OptionsDialog.shiftIsPressed((int)context.getModifiers())) && !(checkoutFileDialog = new CheckoutFileDialog(project, files)).showAndGet()) {
            return CvsHandler.NULL;
        }
        return CommandCvsHandler.createCheckoutFileHandler(filesArray, CvsConfiguration.getInstance(project), VcsConfiguration.getInstance((Project)project).getCheckoutOption());
    }

    @Override
    protected void beforeActionPerformed(VcsContext context) {
        super.beforeActionPerformed(context);
        this.myModifiedFiles = new ReplaceFileConfirmationDialog(context.getProject(), CvsBundle.getCheckoutOperationName()).collectModifiedFiles(context.getSelectedFiles());
    }
}

