/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui.experts.checkout;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsBrowser.CvsElement;
import com.intellij.cvsSupport2.cvsBrowser.CvsFile;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagsProviderOnEnvironment;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.ui.DateOrRevisionOrTagSettings;
import com.intellij.cvsSupport2.ui.ChangeKeywordSubstitutionPanel;
import com.intellij.cvsSupport2.ui.experts.WizardStep;
import com.intellij.cvsSupport2.ui.experts.checkout.CheckoutWizard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.checkout.CheckoutStrategy;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;

public class ChooseCheckoutMode
extends WizardStep {
    private File mySelectedLocation;
    private final Collection<File> myCvsPaths = new ArrayList<File>();
    private final DefaultListModel myCheckoutModeModel = new DefaultListModel();
    private final JList myCheckoutModeList = new JBList((ListModel)this.myCheckoutModeModel);
    private final JCheckBox myMakeNewFilesReadOnly = new JCheckBox(CvsBundle.message((String)"checkbox.make.new.files.read.only", (Object[])new Object[0]));
    private final JCheckBox myPruneEmptyDirectories = new JCheckBox(CvsBundle.message((String)"checkbox.prune.empty.directories", (Object[])new Object[0]));
    private final ChangeKeywordSubstitutionPanel myChangeKeywordSubstitutionPanel;
    private final DateOrRevisionOrTagSettings myDateOrRevisionOrTagSettings;
    private final JPanel myCenterPanel = new JPanel(new CardLayout());
    @NonNls
    public static final String LIST = "LIST";
    @NonNls
    public static final String MESSAGE = "MESSSAGE";
    @NonNls
    private final JLabel myMessage = new JLabel("XXX");
    private CvsRootConfiguration myConfiguration = null;

    public ChooseCheckoutMode(Project project, CheckoutWizard wizard) {
        super("###", wizard);
        this.myCheckoutModeList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                CheckoutStrategy checkoutStrategy = (CheckoutStrategy)value;
                this.append(checkoutStrategy.getResult().getAbsolutePath(), new SimpleTextAttributes(0, list.getForeground()));
                this.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/cvsSupport2/ui/experts/checkout/ChooseCheckoutMode$1", "customizeCellRenderer"));
            }
        });
        this.myCheckoutModeList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ChooseCheckoutMode.this.getWizard().updateButtons();
            }
        });
        this.myCheckoutModeList.setSelectionMode(0);
        CvsApplicationLevelConfiguration config = CvsApplicationLevelConfiguration.getInstance();
        this.myMakeNewFilesReadOnly.setSelected(config.MAKE_CHECKED_OUT_FILES_READONLY);
        this.myPruneEmptyDirectories.setSelected(config.CHECKOUT_PRUNE_EMPTY_DIRECTORIES);
        this.myChangeKeywordSubstitutionPanel = new ChangeKeywordSubstitutionPanel(KeywordSubstitution.getValue((String)config.CHECKOUT_KEYWORD_SUBSTITUTION));
        this.myCenterPanel.add(LIST, ScrollPaneFactory.createScrollPane((Component)this.myCheckoutModeList));
        JPanel messagePanel = new JPanel(new BorderLayout(2, 4));
        messagePanel.add((Component)this.myMessage, "North");
        messagePanel.setBackground(UIUtil.getTableBackground());
        this.myMessage.setBackground(UIUtil.getTableBackground());
        this.myCenterPanel.add(MESSAGE, ScrollPaneFactory.createScrollPane((Component)messagePanel));
        this.myDateOrRevisionOrTagSettings = new DateOrRevisionOrTagSettings(new TagsProviderOnEnvironment(){

            @Override
            @Nullable
            protected CvsEnvironment getCvsEnvironment() {
                return ChooseCheckoutMode.this.getWizard().getSelectedConfiguration();
            }

            @Override
            public String getModule() {
                CvsElement[] selectedElements = ChooseCheckoutMode.this.getWizard().getSelectedElements();
                String module = null;
                for (CvsElement element : selectedElements) {
                    String checkoutPath = element.getCheckoutPath();
                    if (module == null) {
                        module = checkoutPath;
                        continue;
                    }
                    String commonParentModule = ChooseCheckoutMode.findCommonParentModule(module, checkoutPath);
                    if (commonParentModule == null) {
                        return super.getModule();
                    }
                    module = commonParentModule;
                }
                return module;
            }
        }, project);
        this.init();
    }

    private static String findCommonParentModule(String module1, String module2) {
        int diff = ChooseCheckoutMode.indexOfFirstDifference(module1, module2);
        if (diff == 0) {
            return null;
        }
        if (diff == module1.length()) {
            return module1;
        }
        if (module1.charAt(diff - 1) == '/') {
            return module1.substring(0, diff);
        }
        int index = module1.lastIndexOf(47, diff);
        if (index < 0) {
            return null;
        }
        return module1.substring(0, index);
    }

    private static int indexOfFirstDifference(@NotNull String a, @NotNull String b) {
        if (a == null) {
            ChooseCheckoutMode.$$$reportNull$$$0(0);
        }
        if (b == null) {
            ChooseCheckoutMode.$$$reportNull$$$0(1);
        }
        int max = Math.min(a.length(), b.length());
        for (int i = 0; i < max; ++i) {
            char c = a.charAt(i);
            if (c == b.charAt(i)) continue;
            return i;
        }
        return max;
    }

    @Override
    protected CheckoutWizard getWizard() {
        return (CheckoutWizard)super.getWizard();
    }

    @Override
    public boolean nextIsEnabled() {
        if (this.myCvsPaths.size() == 1) {
            return this.myCheckoutModeList.getSelectedValue() != null;
        }
        return true;
    }

    @Override
    protected JComponent createComponent() {
        JPanel result = new JPanel(new BorderLayout(4, 2));
        result.add((Component)this.myCenterPanel, "Center");
        result.add((Component)this.createOptionsPanel(), "South");
        return result;
    }

    private JPanel createOptionsPanel() {
        JPanel result = new JPanel((LayoutManager)new VerticalFlowLayout());
        result.add(this.myMakeNewFilesReadOnly);
        result.add(this.myPruneEmptyDirectories);
        result.add(this.myChangeKeywordSubstitutionPanel.getComponent());
        result.add(this.myDateOrRevisionOrTagSettings.getPanel());
        return result;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myCheckoutModeList;
    }

    @Override
    public void activate() {
        File selectedLocation = this.getWizard().getSelectedLocation();
        Collection<File> cvsPaths = this.getSelectedFiles();
        if (!FileUtil.filesEqual((File)selectedLocation, (File)this.mySelectedLocation) || !Comparing.equal(cvsPaths, this.myCvsPaths)) {
            this.mySelectedLocation = selectedLocation;
            this.myCvsPaths.clear();
            this.myCvsPaths.addAll(cvsPaths);
            if (this.myCvsPaths.size() == 1) {
                this.show(LIST);
                this.rebuildList();
            } else {
                this.setStepTitle(CvsBundle.message((String)"info.text.selected.modules.will.be.checked.out.to", (Object[])new Object[0]));
                StringBuilder message = this.composeLocationsMessage();
                this.myMessage.setText(message.toString());
                this.show(MESSAGE);
                this.getWizard().updateButtons();
            }
        } else if (selectedLocation == null) {
            this.getWizard().updateButtons();
        }
        CvsRootConfiguration configuration = this.getWizard().getSelectedConfiguration();
        if (this.myConfiguration != configuration) {
            this.myDateOrRevisionOrTagSettings.updateFrom(configuration.DATE_OR_REVISION_SETTINGS);
            this.myConfiguration = configuration;
        }
    }

    private StringBuilder composeLocationsMessage() {
        StringBuilder message = new StringBuilder("<html><p>");
        message.append(this.mySelectedLocation.getAbsolutePath()).append("</p>");
        for (File file : this.myCvsPaths) {
            message.append("<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-").append(file.getPath()).append("</p>");
        }
        return message;
    }

    private Collection<File> getSelectedFiles() {
        HashSet allFiles = new HashSet();
        CvsElement[] selection = this.getWizard().getSelectedElements();
        if (selection == null) {
            return allFiles;
        }
        for (CvsElement cvsElement : selection) {
            allFiles.add(new File(cvsElement.getCheckoutPath()));
        }
        ArrayList<File> result = new ArrayList<File>();
        for (File file2 : allFiles) {
            if (ChooseCheckoutMode.hasParentIn((Collection<File>)allFiles, file2)) continue;
            result.add(file2);
        }
        Collections.sort(result, (file, file1) -> file.getPath().compareTo(file1.getPath()));
        return result;
    }

    private static boolean hasParentIn(Collection<File> allFiles, File file) {
        String filePath = file.getPath();
        for (File file1 : allFiles) {
            if (FileUtil.filesEqual((File)file1, (File)file) || !filePath.startsWith(file1.getPath())) continue;
            return true;
        }
        return false;
    }

    private void rebuildList() {
        File selected = this.myCvsPaths.iterator().next();
        this.setStepTitle(CvsBundle.message((String)"dialog.title.check.out.to", (Object[])new Object[]{selected}));
        this.myCheckoutModeModel.removeAllElements();
        boolean forFile = this.getWizard().getSelectedElements()[0] instanceof CvsFile;
        CheckoutStrategy[] strategies = CheckoutStrategy.createAllStrategies((File)this.mySelectedLocation, (File)selected, (boolean)forFile);
        HashSet results = new HashSet();
        ArrayList<CheckoutStrategy> resultModes = new ArrayList<CheckoutStrategy>();
        for (CheckoutStrategy strategy : strategies) {
            File resultFile = strategy.getResult();
            if (resultFile == null || results.contains(resultFile)) continue;
            results.add(resultFile);
            resultModes.add(strategy);
        }
        Collections.sort(resultModes);
        for (CheckoutStrategy resultMode : resultModes) {
            this.myCheckoutModeModel.addElement(resultMode);
        }
        this.myCheckoutModeList.setSelectedIndex(0);
    }

    private void show(String mode) {
        ((CardLayout)this.myCenterPanel.getLayout()).show(this.myCenterPanel, mode);
    }

    public boolean getMakeNewFilesReadOnly() {
        return this.myMakeNewFilesReadOnly.isSelected();
    }

    public boolean getPruneEmptyDirectories() {
        return this.myPruneEmptyDirectories.isSelected();
    }

    public boolean useAlternativeCheckoutLocation() {
        if (this.myCvsPaths.size() == 1) {
            CheckoutStrategy checkoutStrategy = (CheckoutStrategy)this.myCheckoutModeList.getSelectedValue();
            return checkoutStrategy.useAlternativeCheckoutLocation();
        }
        return false;
    }

    public File getCheckoutDirectory() {
        if (this.myCvsPaths.size() == 1) {
            CheckoutStrategy checkoutStrategy = (CheckoutStrategy)this.myCheckoutModeList.getSelectedValue();
            return checkoutStrategy.getCheckoutDirectory();
        }
        return this.mySelectedLocation;
    }

    public KeywordSubstitution getKeywordSubstitution() {
        return this.myChangeKeywordSubstitutionPanel.getKeywordSubstitution();
    }

    public void saveDateOrRevisionSettings(CvsRootConfiguration configuration) {
        this.myDateOrRevisionOrTagSettings.saveTo(configuration.DATE_OR_REVISION_SETTINGS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "a";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "b";
                break;
            }
        }
        objectArray[1] = "com/intellij/cvsSupport2/ui/experts/checkout/ChooseCheckoutMode";
        objectArray[2] = "indexOfFirstDifference";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

