/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.actions.BasicAction;
import git4idea.checkout.GitCheckoutProvider;
import git4idea.checkout.GitCloneDialog;
import git4idea.commands.Git;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubCheckoutProvider
implements CheckoutProvider {
    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener) {
        List availableRepos;
        if (project == null) {
            GithubCheckoutProvider.$$$reportNull$$$0(0);
        }
        if (!GithubUtil.testGitExecutable(project)) {
            return;
        }
        BasicAction.saveAll();
        try {
            availableRepos = (List)GithubUtil.computeValueInModalIO(project, "Access to GitHub", indicator -> {
                if (project == null) {
                    GithubCheckoutProvider.$$$reportNull$$$0(1);
                }
                return (List)GithubUtil.runTask(project, GithubAuthDataHolder.createFromSettings(), indicator, connection -> GithubApiUtil.getAvailableRepos(connection));
            });
        }
        catch (IOException e) {
            GithubNotifications.showError(project, "Couldn't get the list of GitHub repositories", e);
            return;
        }
        Collections.sort(availableRepos, (r1, r2) -> {
            int comparedOwners = r1.getUserName().compareTo(r2.getUserName());
            return comparedOwners != 0 ? comparedOwners : r1.getName().compareTo(r2.getName());
        });
        GitCloneDialog dialog = new GitCloneDialog(project);
        dialog.prependToHistory("-----------------------------------------------");
        for (int i = availableRepos.size() - 1; i >= 0; --i) {
            dialog.prependToHistory(GithubUrlUtil.getCloneUrl(((GithubRepo)availableRepos.get(i)).getFullPath()));
        }
        if (!dialog.showAndGet()) {
            return;
        }
        dialog.rememberSettings();
        VirtualFile destinationParent = LocalFileSystem.getInstance().findFileByIoFile(new File(dialog.getParentDirectory()));
        if (destinationParent == null) {
            return;
        }
        String sourceRepositoryURL = dialog.getSourceRepositoryURL();
        String directoryName = dialog.getDirectoryName();
        String parentDirectory = dialog.getParentDirectory();
        Git git = (Git)ServiceManager.getService(Git.class);
        GitCheckoutProvider.clone((Project)project, (Git)git, (CheckoutProvider.Listener)listener, (VirtualFile)destinationParent, (String)sourceRepositoryURL, (String)directoryName, (String)parentDirectory);
    }

    public String getVcsName() {
        return "Git_Hub";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "org/jetbrains/plugins/github/extensions/GithubCheckoutProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doCheckout";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doCheckout$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

