/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jdom.Element;

@State(name="Registry", storages={@Storage(value="ide.general.xml"), @Storage(value="other.xml", deprecated=true)})
public class RegistryState
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(RegistryState.class);

    @Override
    public Element getState() {
        return Registry.getInstance().getState();
    }

    @Override
    public void loadState(Element state) {
        List enabledIds;
        Registry.getInstance().loadState(state);
        TreeMap userProperties = new TreeMap(Registry.getInstance().getUserProperties());
        userProperties.remove("ide.firstStartup");
        if (!userProperties.isEmpty()) {
            LOG.info("Registry values changed by user:");
            for (Map.Entry entry : userProperties.entrySet()) {
                LOG.info("  " + (String)entry.getKey() + " = " + (String)entry.getValue());
            }
        }
        if (!(enabledIds = Arrays.stream(Experiments.EP_NAME.getExtensions()).filter(e -> Experiments.isFeatureEnabled(e.id)).map(e -> e.id).collect(Collectors.toList())).isEmpty()) {
            LOG.info("Experimental features enabled for user: " + StringUtil.join(enabledIds, (String)", "));
        }
    }
}

