/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.processor;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.extractor.Utils;
import com.intellij.psi.codeStyle.extractor.differ.Differ;
import com.intellij.psi.codeStyle.extractor.differ.LangCodeStyleExtractor;
import com.intellij.psi.codeStyle.extractor.processor.CodeStyleDeriveProcessor;
import com.intellij.psi.codeStyle.extractor.values.Gens;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GenProcessor
extends CodeStyleDeriveProcessor {
    private static DateFormat formatter = new SimpleDateFormat("mm:ss");

    public GenProcessor(LangCodeStyleExtractor langExtractor) {
        super(langExtractor);
    }

    @Override
    public Gens runWithProgress(Project project, CodeStyleSettings settings, PsiFile file, ProgressIndicator indicator) {
        Gens origGens = new Gens(this.getFormattingValues(settings, file.getLanguage()));
        Gens forSelection = origGens.copy();
        Differ differ = this.myLangExtractor.getDiffer(project, file, settings);
        forSelection.dropToInitial();
        Utils.resetRandom();
        long startTime = System.nanoTime();
        Utils.adjustValuesGA(forSelection, differ, indicator);
        this.reportResult("GA", forSelection, differ, startTime, file.getName());
        startTime = System.nanoTime();
        Utils.adjustValuesMin(forSelection, differ, indicator);
        this.reportResult("MIN", forSelection, differ, startTime, file.getName());
        return forSelection;
    }

    private void reportResult(String label, Gens gens, Differ differ, long startTime, String fileName) {
        Date date = new Date((System.nanoTime() - startTime) / 1000000L);
        System.out.println(fileName + ": " + label + " range:" + differ.getDifference(gens) + "  Execution Time: " + formatter.format(date));
    }
}

