/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import java.util.HashMap;
import java.util.Map;

public class QueueProcessorRemovePartner<Key, Task> {
    private final Map<Key, Task> myMap;
    private final QueueProcessor<Key> myProcessor;
    private final Consumer<Task> myConsumer;
    private final Object myLock;

    public QueueProcessorRemovePartner(Project project, Consumer<Task> consumer) {
        this.myConsumer = consumer;
        this.myMap = new HashMap<Key, Task>();
        this.myLock = new Object();
        this.myProcessor = new QueueProcessor(key -> {
            Task task;
            Object object = this.myLock;
            synchronized (object) {
                task = this.myMap.remove(key);
            }
            if (task != null) {
                this.myConsumer.consume(task);
            }
        }, project.getDisposed(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Key key, Task task) {
        Object object = this.myLock;
        synchronized (object) {
            this.myMap.put(key, task);
        }
        this.myProcessor.add(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Key key) {
        Object object = this.myLock;
        synchronized (object) {
            this.myMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.myLock;
        synchronized (object) {
            this.myMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Key key) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myMap.containsKey(key);
        }
    }
}

