/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.util;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpsPathUtil {
    public static boolean isUnder(Set<File> ancestors, File file) {
        if (ancestors.isEmpty()) {
            return false;
        }
        File current = file;
        while (current != null) {
            if (ancestors.contains(current)) {
                return true;
            }
            current = FileUtilRt.getParentFile((File)current);
        }
        return false;
    }

    public static File urlToFile(String url) {
        return new File(JpsPathUtil.urlToOsPath(url));
    }

    @NotNull
    public static String urlToOsPath(@NotNull String url) {
        if (url == null) {
            JpsPathUtil.$$$reportNull$$$0(0);
        }
        String string = FileUtilRt.toSystemDependentName((String)JpsPathUtil.urlToPath(url));
        if (string == null) {
            JpsPathUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null")
    public static String urlToPath(@Nullable String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("file://")) {
            return url.substring("file://".length());
        }
        if (url.startsWith("jar://") && (url = url.substring("jar://".length())).endsWith("!/")) {
            url = url.substring(0, url.length() - "!/".length());
        }
        return url;
    }

    @NotNull
    public static String fixURLforIDEA(@NotNull String url) {
        int idx;
        if (url == null) {
            JpsPathUtil.$$$reportNull$$$0(2);
        }
        if ((idx = url.indexOf(":/")) >= 0 && idx + 2 < url.length() && url.charAt(idx + 2) != '/') {
            String prefix = url.substring(0, idx);
            String suffix = url.substring(idx + 2);
            url = SystemInfoRt.isWindows ? prefix + "://" + suffix : prefix + ":///" + suffix;
        }
        String string = url;
        if (string == null) {
            JpsPathUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static String pathToUrl(String path2) {
        return "file://" + path2;
    }

    public static String getLibraryRootUrl(File file) {
        String path2 = FileUtilRt.toSystemIndependentName((String)file.getAbsolutePath());
        return file.isDirectory() ? "file://" + path2 : "jar://" + path2 + "!/";
    }

    public static boolean isJrtUrl(@NotNull String url) {
        if (url == null) {
            JpsPathUtil.$$$reportNull$$$0(4);
        }
        return url.startsWith("jrt://");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/util/JpsPathUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/util/JpsPathUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToOsPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fixURLforIDEA";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "urlToOsPath";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fixURLforIDEA";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isJrtUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

