/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.Locale;

public class BoundedBreakIteratorScanner
extends BreakIterator {
    private final BreakIterator mainBreak;
    private final BreakIterator innerBreak;
    private final int maxLen;
    private int lastPrecedingOffset = -1;
    private int windowStart = -1;
    private int windowEnd = -1;
    private int innerStart = -1;
    private int innerEnd = 0;

    private BoundedBreakIteratorScanner(BreakIterator mainBreak, BreakIterator innerBreak, int maxLen) {
        this.mainBreak = mainBreak;
        this.innerBreak = innerBreak;
        this.maxLen = maxLen;
    }

    @Override
    public CharacterIterator getText() {
        return this.mainBreak.getText();
    }

    @Override
    public void setText(CharacterIterator newText) {
        this.reset();
        this.mainBreak.setText(newText);
        this.innerBreak.setText(newText);
    }

    @Override
    public void setText(String newText) {
        this.reset();
        this.mainBreak.setText(newText);
        this.innerBreak.setText(newText);
    }

    private void reset() {
        this.lastPrecedingOffset = -1;
        this.windowStart = -1;
        this.windowEnd = -1;
        this.innerStart = -1;
        this.innerEnd = 0;
    }

    @Override
    public int preceding(int offset) {
        if (offset < this.lastPrecedingOffset) {
            throw new IllegalArgumentException("offset < lastPrecedingOffset: usage doesn't look like UnifiedHighlighter");
        }
        if (offset > this.windowStart && offset < this.windowEnd) {
            this.innerStart = this.innerEnd;
            this.innerEnd = this.windowEnd;
        } else {
            this.windowStart = this.innerStart = this.mainBreak.preceding(offset);
            this.windowEnd = this.innerEnd = this.mainBreak.following(offset - 1);
        }
        if (this.innerEnd - this.innerStart > this.maxLen) {
            int remaining;
            if (offset - this.maxLen > this.innerStart) {
                this.innerStart = Math.max(this.innerStart, this.innerBreak.preceding(offset - this.maxLen));
            }
            if (offset + (remaining = Math.max(0, this.maxLen - (offset - this.innerStart))) < this.windowEnd) {
                this.innerEnd = Math.min(this.windowEnd, this.innerBreak.following(offset + remaining));
            }
        }
        this.lastPrecedingOffset = offset - 1;
        return this.innerStart;
    }

    @Override
    public int following(int offset) {
        if (offset != this.lastPrecedingOffset || this.innerEnd == -1) {
            throw new IllegalArgumentException("offset != lastPrecedingOffset: usage doesn't look like UnifiedHighlighter");
        }
        return this.innerEnd;
    }

    public static BreakIterator getSentence(Locale locale, int maxLen) {
        BreakIterator sBreak = BreakIterator.getSentenceInstance(locale);
        BreakIterator wBreak = BreakIterator.getWordInstance(locale);
        return new BoundedBreakIteratorScanner(sBreak, wBreak, maxLen);
    }

    @Override
    public int current() {
        return this.innerEnd;
    }

    @Override
    public int first() {
        throw new IllegalStateException("first() should not be called in this context");
    }

    @Override
    public int next() {
        throw new IllegalStateException("next() should not be called in this context");
    }

    @Override
    public int last() {
        throw new IllegalStateException("last() should not be called in this context");
    }

    @Override
    public int next(int n) {
        throw new IllegalStateException("next(n) should not be called in this context");
    }

    @Override
    public int previous() {
        throw new IllegalStateException("previous() should not be called in this context");
    }
}

