/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.SB;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MoldenReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;
import org.qcschema.QCSchemaUnits;

public class QCJSONReader
extends MoldenReader {
    private Map<String, Object> job;
    private int jobCount;
    private int modelCount;
    private boolean haveEnergy = true;
    String lastBasisID = null;

    @Override
    protected void initializeReader() {
        super.initializeReader();
        SB sb = new SB();
        try {
            while (this.rd() != null) {
                sb.append(this.line);
            }
            Lst json = this.vwr.parseJSONArray(sb.toString());
            Logger.info((String)json.get(0).toString());
            this.jobCount = json.size() - 2;
            for (int i = 0; i < this.jobCount; ++i) {
                this.processJob((Map)json.get(i + 2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.continuing = false;
    }

    private void processJob(Map<String, Object> job) throws Exception {
        this.job = job;
        this.readSteps();
    }

    @Override
    public void finalizeSubclassReader() throws Exception {
        this.finalizeReaderASCR();
    }

    private void readSteps() throws Exception {
        ArrayList steps = QCSchemaUnits.getList(this.job, (String)"steps");
        int nSteps = steps.size();
        for (int iStep = 0; iStep < nSteps; ++iStep) {
            if (!this.doGetModel(++this.modelCount, null)) {
                if (this.checkLastModel()) continue;
                return;
            }
            this.asc.newAtomSet();
            Map step = (Map)steps.get(iStep);
            Map<String, Object> topology = QCJSONReader.getMapSafely(step, "topology");
            Map<String, Object> atoms = QCJSONReader.getMapSafely(topology, "atoms");
            String[] symbols = QCSchemaUnits.getStringArray(atoms, (String)"symbol");
            int[] atomNumbers = QCSchemaUnits.getIntArray(atoms, (String)"atom_number");
            String[] atom_names = QCSchemaUnits.getStringArray(atoms, (String)"atom_names");
            double[] coords = QCSchemaUnits.getDoubleArray(atoms, (String)"coords");
            this.modelAtomCount = coords.length / 3;
            double f = QCSchemaUnits.getConversionFactor(atoms, (String)"coords", (String)"angstroms");
            boolean isFractional = f == 0.0;
            this.setFractionalCoordinates(isFractional);
            if (isFractional) {
                f = QCSchemaUnits.getConversionFactor(atoms, (String)"unit_cell", (String)"angstroms");
                double[] cell = QCSchemaUnits.getDoubleArray(atoms, (String)"unit_cell");
                if (cell == null) {
                    Logger.error((String)"topology.unit_cell is missing even though atoms are listed as fractional");
                } else {
                    for (int i = 0; i < 6; ++i) {
                        switch (i) {
                            case 3: {
                                f = 1.0;
                            }
                        }
                        this.setUnitCellItem(i, (float)(cell[i] * f));
                    }
                }
            }
            int pt = 0;
            for (int i = 0; i < this.modelAtomCount; ++i) {
                Atom atom = this.asc.addNewAtom();
                this.setAtomCoordXYZ(atom, (float)(coords[pt++] * f), (float)(coords[pt++] * f), (float)(coords[pt++] * f));
                String sym = symbols == null ? JmolAdapter.getElementSymbol((int)atomNumbers[i]) : symbols[i];
                atom.atomName = atom_names == null ? sym : atom_names[i];
                atom.elementNumber = (short)(atomNumbers == null ? JmolAdapter.getElementNumber((String)sym) : atomNumbers[i]);
            }
            if (this.doReadMolecularOrbitals) {
                this.readMolecularOrbitals(QCJSONReader.getMapSafely(step, "molecular_orbitals"));
                this.clearOrbitals();
            }
            this.applySymmetryAndSetTrajectory();
            if (!this.loadVibrations) continue;
            this.readFreqsAndModes(QCSchemaUnits.getList((Object)step, (String)"vibrations"));
        }
    }

    private boolean readFreqsAndModes(ArrayList<Object> vibrations) throws Exception {
        if (vibrations != null) {
            int n = vibrations.size();
            for (int i = 0; i < n; ++i) {
                Map vib = (Map)vibrations.get(i);
                double freq = QCSchemaUnits.getDouble((Map)vib, (String)"frequency", (String)"cm-1");
                double[] vectors = QCSchemaUnits.getDoubleArray((Object)vib, (String)"vectors");
                if (i > 0) {
                    this.asc.cloneLastAtomSet();
                }
                this.asc.setAtomSetFrequency(null, null, "" + freq, "cm-1");
                int i0 = this.asc.getLastAtomSetAtomIndex();
                int pt = 0;
                for (int j = 0; j < this.modelAtomCount; ++j) {
                    this.asc.addVibrationVector(j + i0, (float)(vectors[pt++] * 0.529177188873291), (float)(vectors[pt++] * 0.529177188873291), (float)(vectors[pt++] * 0.529177188873291));
                }
            }
        }
        return true;
    }

    private boolean readMolecularOrbitals(Map<String, Object> molecular_orbitals) throws Exception {
        ArrayList units;
        if (molecular_orbitals == null) {
            return false;
        }
        String moBasisID = molecular_orbitals.get("basis_id").toString();
        if (!this.readBasis(moBasisID)) {
            return false;
        }
        Boolean isNormalized = (Boolean)molecular_orbitals.get("__jmol_normalized");
        if (isNormalized != null && isNormalized.booleanValue()) {
            this.moData.put("isNormalized", isNormalized);
        }
        this.calculationType = (String)molecular_orbitals.get("__jmol_calculation_type");
        if (this.calculationType == null) {
            this.calculationType = "?";
        }
        this.moData.put("calculationType", this.calculationType);
        ArrayList mos = QCSchemaUnits.getList(molecular_orbitals, (String)"orbitals");
        int n = mos.size();
        for (int i = 0; i < n; ++i) {
            Map thisMO = (Map)mos.get(i);
            double energy = QCSchemaUnits.getDouble((Map)thisMO, (String)"energy", (String)"ev");
            double occupancy = QCSchemaUnits.getDouble((Map)thisMO, (String)"occupancy", null);
            String symmetry = (String)thisMO.get("symmetry");
            String spin = (String)thisMO.get("type");
            if (spin != null) {
                if (spin.indexOf("beta") >= 0) {
                    this.alphaBeta = "beta";
                } else if (spin.indexOf("alpha") >= 0) {
                    this.alphaBeta = "alpha";
                }
            }
            float[] coefs = this.toFloatArray(QCSchemaUnits.getDoubleArray((Object)thisMO, (String)"coefficients"));
            this.line = "" + symmetry;
            if (!this.filterMO()) continue;
            Hashtable<String, Object> mo = new Hashtable<String, Object>();
            mo.put("coefficients", coefs);
            if (Double.isNaN(energy)) {
                this.haveEnergy = false;
            } else {
                mo.put("energy", Float.valueOf((float)energy));
            }
            if (!Double.isNaN(occupancy)) {
                mo.put("occupancy", Float.valueOf((float)occupancy));
            }
            if (symmetry != null) {
                mo.put("symmetry", symmetry);
            }
            if (this.alphaBeta.length() > 0) {
                mo.put("type", this.alphaBeta);
            }
            this.setMO(mo);
            if (!this.debugging) continue;
            Logger.debug((String)(coefs.length + " coefficients in MO " + this.orbitals.size()));
        }
        if (this.debugging) {
            Logger.debug((String)("read " + this.orbitals.size() + " MOs"));
        }
        String sunits = (units = QCSchemaUnits.getList(molecular_orbitals, (String)"orbitals_energy_units")) == null ? null : units.get(0).toString();
        this.setMOs(sunits == null || sunits.equals("?") ? "?" : sunits);
        if (this.haveEnergy && this.doSort) {
            this.sortMOs();
        }
        return false;
    }

    private float[] toFloatArray(double[] da) {
        float[] fa = new float[da.length];
        int j = da.length;
        while (--j >= 0) {
            fa[j] = (float)da[j];
        }
        return fa;
    }

    private boolean readBasis(String moBasisID) throws Exception {
        Map<String, Object> moBasisData = QCJSONReader.getMapSafely(this.job, "mo_bases");
        Map<String, Object> moBasis = QCJSONReader.getMapSafely(moBasisData, moBasisID);
        if (moBasis == null) {
            Logger.error((String)("No job.mo_bases entry for " + moBasisID));
            return false;
        }
        if (moBasisID == this.lastBasisID) {
            return true;
        }
        this.lastBasisID = moBasisID;
        ArrayList listG = QCSchemaUnits.getList(moBasis, (String)"gaussians");
        ArrayList listS = QCSchemaUnits.getList(moBasis, (String)"shells");
        if (listG == null && listS == null) {
            listG = listS = QCSchemaUnits.getList(moBasis, (String)"slaters");
        }
        if (listG == null != (listS == null)) {
            Logger.error((String)"gaussians/shells or slaters missing");
            return false;
        }
        if (listG == listS) {
            this.readSlaterBasis(listS);
        } else {
            this.readGaussianBasis(listG, listS);
        }
        return true;
    }

    boolean readSlaterBasis(ArrayList<Object> listS) throws Exception {
        this.nCoef = listS.size();
        for (int i = 0; i < this.nCoef; ++i) {
            double[] a = QCSchemaUnits.getDoubleArray((Object)listS.get(i), null);
            this.addSlater((int)a[0], (int)a[1], (int)a[2], (int)a[3], (int)a[4], (float)a[5], (float)a[6]);
        }
        this.setSlaters(false, false);
        return true;
    }

    private boolean readGaussianBasis(ArrayList<Object> listG, ArrayList<Object> listS) throws Exception {
        this.shells = new Lst();
        for (int i = 0; i < listS.size(); ++i) {
            this.shells.addLast((Object)QCSchemaUnits.getIntArray((Object)listS.get(i), null));
        }
        int gaussianPtr = listG.size();
        float[][] garray = AU.newFloat2((int)gaussianPtr);
        for (int i = 0; i < gaussianPtr; ++i) {
            garray[i] = this.toFloatArray(QCSchemaUnits.getDoubleArray((Object)listG.get(i), null));
        }
        this.moData.put("shells", this.shells);
        this.moData.put("gaussians", garray);
        Logger.info((String)(this.shells.size() + " slater shells read"));
        Logger.info((String)(garray.length + " gaussian primitives read"));
        this.asc.setCurrentModelInfo("moData", (Object)this.moData);
        return false;
    }

    private void sortMOs() {
        Object[] list = this.orbitals.toArray(new Object[this.orbitals.size()]);
        Arrays.sort(list, new BasisFunctionReader.MOEnergySorter());
        this.orbitals.clear();
        for (int i = 0; i < list.length; ++i) {
            this.orbitals.addLast((Object)((Map)list[i]));
        }
    }

    private static Map<String, Object> getMapSafely(Map<String, Object> map, String key) {
        return map == null ? null : (Map)map.get(key);
    }
}

