/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.IOException;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyString;
import org.jruby.ext.ripper.ArgsTailHolder;
import org.jruby.ext.ripper.RipperLexer;
import org.jruby.ext.ripper.StrTerm;
import org.jruby.ext.ripper.SyntaxException;
import org.jruby.lexer.LexerSource;
import org.jruby.lexer.yacc.StackState;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RipperParserBase {
    private IRubyObject currentArg;
    protected IRubyObject ripper;
    protected ThreadContext context;
    protected RipperLexer lexer;
    protected StaticScope currentScope;
    protected boolean inDefinition;
    protected boolean yydebug;
    protected boolean isError;
    protected int inSingleton;

    public RipperParserBase(ThreadContext context, IRubyObject ripper2, LexerSource source2) {
        this.context = context;
        this.ripper = ripper2;
        this.lexer = new RipperLexer(this, source2);
    }

    static int associateEncoding(ByteList buffer, Encoding ASCII8BIT_ENCODING, int codeRange) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reset() {
    }

    public Object yyparse(RipperLexer yyLex) throws IOException {
        return null;
    }

    public Object yyparse(RipperLexer yyLex, Object debugger) throws IOException {
        return null;
    }

    public IRubyObject parse(boolean isDebug) throws IOException {
        this.reset();
        this.lexer.parser_prepare();
        return (IRubyObject)this.yyparse(this.lexer, null);
    }

    public IRubyObject arg_add_optblock(IRubyObject arg1, IRubyObject arg2) {
        if (arg2 == null) {
            return this.dispatch("on_args_add_block", arg1, this.getRuntime().getFalse());
        }
        if (arg2.isNil()) {
            return arg1;
        }
        return this.dispatch("on_args_add_block", arg1, arg2);
    }

    public IRubyObject arg_var(IRubyObject identifier) {
        String name2 = this.lexer.getIdent();
        StaticScope current2 = this.getCurrentScope();
        if (name2 == "_") {
            int count2 = 0;
            while (current2.exists(name2) >= 0) {
                name2 = "_$" + count2++;
            }
        }
        current2.addVariableThisScope(name2);
        return identifier;
    }

    public IRubyObject assignable(IRubyObject name2) {
        if (!(name2 instanceof RubyString)) {
            return name2;
        }
        String javaName = name2.asJavaString();
        if (javaName.equals("self")) {
            this.yyerror("Can't change the value of self");
        } else if (javaName.equals("nil")) {
            this.yyerror("Can't assign to nil");
        } else if (javaName.equals("true")) {
            this.yyerror("Can't assign to true");
        } else if (javaName.equals("false")) {
            this.yyerror("Can't assign to false");
        } else if (javaName.equals("__FILE__")) {
            this.yyerror("Can't assign to __FILE__");
        } else if (javaName.equals("__LINE__")) {
            this.yyerror("Can't assign to __LINE__");
        } else {
            if (Character.isUpperCase(javaName.charAt(0))) {
                if (this.isInDef() || this.isInSingle()) {
                    this.dispatch("on_assign_error", name2);
                }
                return name2;
            }
            if (javaName.charAt(0) == '@') {
                if (javaName.charAt(1) == '@') {
                    return name2;
                }
                return name2;
            }
            if (javaName.charAt(0) == '$') {
                return name2;
            }
        }
        this.currentScope.assign(this.lexer.getPosition(), javaName.intern(), null);
        return name2;
    }

    public IRubyObject dispatch(String method_name) {
        return Helpers.invoke(this.context, this.ripper, method_name);
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1), this.escape(arg2));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1), this.escape(arg2), this.escape(arg3));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1), this.escape(arg2), this.escape(arg3), this.escape(arg4));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1), this.escape(arg2), this.escape(arg3), this.escape(arg4), this.escape(arg5));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1), this.escape(arg2), this.escape(arg3), this.escape(arg4), this.escape(arg5), this.escape(arg6), this.escape(arg7));
    }

    public IRubyObject escape(IRubyObject arg2) {
        return arg2 == null ? this.context.runtime.getNil() : arg2;
    }

    public IRubyObject formal_argument(IRubyObject identifier) {
        return this.shadowing_lvar(identifier);
    }

    protected void getterIdentifierError(String identifier) {
        throw new SyntaxException("identifier " + identifier + " is not valid", identifier);
    }

    public boolean is_id_var(IRubyObject identifier) {
        String ident = this.lexer.getIdent().intern();
        char c = ident.charAt(0);
        if (c == '$' || c == '@' || Character.toUpperCase(c) == c) {
            return true;
        }
        return this.getCurrentScope().getLocalScope().isDefined(ident) >= 0;
    }

    public boolean is_local_id(String identifier) {
        return this.lexer.isIdentifierChar(identifier.charAt(0));
    }

    public IRubyObject intern(String value2) {
        return this.context.runtime.newSymbol(value2);
    }

    public IRubyObject method_optarg(IRubyObject method, IRubyObject arg2) {
        if (arg2 == null) {
            return method;
        }
        return this.dispatch("on_method_add_arg", method, arg2);
    }

    public IRubyObject keyword_arg(IRubyObject key2, IRubyObject value2) {
        RubyArray array = RubyArray.newArray(this.context.runtime, 2);
        array.append(key2);
        if (value2 != null) {
            array.append(value2);
        } else {
            array.append(this.context.nil);
        }
        return array;
    }

    public IRubyObject new_args(IRubyObject f, IRubyObject o, IRubyObject r, IRubyObject p2, ArgsTailHolder tail) {
        if (tail != null) {
            return this.dispatch("on_params", f, o, r, p2, tail.getKeywordArgs(), tail.getKeywordRestArg(), tail.getBlockArg());
        }
        return this.dispatch("on_params", f, o, r, p2, null, null, null);
    }

    public ArgsTailHolder new_args_tail(IRubyObject kwarg, IRubyObject kwargRest, IRubyObject block) {
        return new ArgsTailHolder(kwarg, kwargRest, block);
    }

    public IRubyObject method_add_block(IRubyObject method, IRubyObject block) {
        return this.dispatch("on_method_add_block", method, block);
    }

    public IRubyObject internalId() {
        return null;
    }

    public IRubyObject new_array(IRubyObject arg2) {
        return this.context.runtime.newArray(arg2);
    }

    public IRubyObject new_assoc(IRubyObject key2, IRubyObject value2) {
        return RubyArray.newArray(this.context.runtime, key2, value2);
    }

    public IRubyObject new_bv(IRubyObject identifier) {
        String ident = this.lexer.getIdent();
        if (!this.is_local_id(ident)) {
            this.getterIdentifierError(ident);
        }
        return this.arg_var(this.shadowing_lvar(identifier));
    }

    public void popCurrentScope() {
        this.currentScope = this.currentScope.getEnclosingScope();
    }

    public void pushBlockScope() {
        this.currentScope = this.getRuntime().getStaticScopeFactory().newBlockScope(this.currentScope);
    }

    public void pushLocalScope() {
        this.currentScope = this.getRuntime().getStaticScopeFactory().newLocalScope(this.currentScope);
    }

    public int getHeredocIndent() {
        return this.lexer.getHeredocIndent();
    }

    public void setHeredocIndent(int indent) {
        this.lexer.setHeredocIndent(indent);
    }

    public void heredoc_dedent(IRubyObject array) {
        if (this.lexer.getHeredocIndent() <= 0) {
            return;
        }
        this.dispatch("on_heredoc_dedent", array, this.getRuntime().newFixnum(this.lexer.getHeredocIndent()));
    }

    public void setCommandStart(boolean value2) {
        this.lexer.commandStart = value2;
    }

    public IRubyObject shadowing_lvar(IRubyObject identifier) {
        String name2 = this.lexer.getIdent();
        if (name2 == "_") {
            return identifier;
        }
        StaticScope current2 = this.getCurrentScope();
        if (current2.isBlockScope()) {
            if (current2.exists(name2) >= 0) {
                this.yyerror("duplicated argument name");
            }
            if (current2.isDefined(name2) >= 0) {
                this.lexer.warning("shadowing outer local variable - %s", name2);
            }
        } else if (current2.exists(name2) >= 0) {
            this.yyerror("duplicated argument name");
        }
        return identifier;
    }

    public StackState getConditionState() {
        return this.lexer.getConditionState();
    }

    public boolean isInDef() {
        return this.inDefinition;
    }

    public boolean isInSingle() {
        return this.inSingleton != 0;
    }

    public StrTerm getStrTerm() {
        return this.lexer.getStrTerm();
    }

    public void setStrTerm(StrTerm object) {
        this.lexer.setStrTerm(object);
    }

    public StackState getCmdArgumentState() {
        return this.lexer.getCmdArgumentState();
    }

    public void compile_error(String message2) {
        this.dispatch("on_parse_error", this.getRuntime().newString(message2));
    }

    public void yyerror(String message2) {
        this.compile_error(message2);
        this.error();
        throw new SyntaxException(message2, message2);
    }

    public void yyerror(String message2, String[] expected, String found) {
        this.error();
        this.compile_error(message2 + ", unexpected " + found + "\n");
    }

    public void error() {
        this.isError = true;
    }

    public Integer getLeftParenBegin() {
        return this.lexer.getLeftParenBegin();
    }

    public void setLeftParenBegin(Integer integer) {
        this.lexer.setLeftParenBegin(integer);
    }

    public void setInDef(boolean inDefinition) {
        this.inDefinition = inDefinition;
    }

    public void setInSingle(int inSingleton) {
        this.inSingleton = inSingleton;
    }

    public int getInSingle() {
        return this.inSingleton;
    }

    public int getBraceNest() {
        return this.lexer.getBraceNest();
    }

    public int getState() {
        return this.lexer.getState();
    }

    public void setBraceNest(int braceNest) {
        this.lexer.setBraceNest(braceNest);
    }

    public void setState(int lexState) {
        this.lexer.setState(lexState);
    }

    public void warning(String message2) {
        if (this.lexer.isVerbose()) {
            this.lexer.warning(message2);
        }
    }

    public void warn(String message2) {
        this.lexer.warn(message2);
    }

    public Integer incrementParenNest() {
        return this.lexer.incrementParenNest();
    }

    public StaticScope getCurrentScope() {
        return this.currentScope;
    }

    public Ruby getRuntime() {
        return this.context.runtime;
    }

    public long getColumn() {
        return this.lexer.column();
    }

    public long getLineno() {
        return this.lexer.lineno();
    }

    public boolean hasStarted() {
        return this.lexer.hasStarted();
    }

    public Encoding encoding() {
        return this.lexer.getEncoding();
    }

    public IRubyObject getCurrentArg() {
        return this.currentArg;
    }

    public void setCurrentArg(IRubyObject arg2) {
        this.currentArg = arg2;
    }

    public boolean getYYDebug() {
        return this.yydebug;
    }

    public void setYYDebug(boolean yydebug2) {
        this.yydebug = yydebug2;
    }

    public boolean isEndSeen() {
        return this.lexer.isEndSeen();
    }

    public boolean isError() {
        return this.isError;
    }

    public ThreadContext getContext() {
        return this.context;
    }
}

