/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.basic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.util.ChecksumUtils;

final class ChecksumCalculator {
    private final List<Checksum> checksums = new ArrayList<Checksum>();
    private final File targetFile;

    public static ChecksumCalculator newInstance(File targetFile, Collection<RepositoryLayout.Checksum> checksums) {
        if (checksums == null || checksums.isEmpty()) {
            return null;
        }
        return new ChecksumCalculator(targetFile, checksums);
    }

    private ChecksumCalculator(File targetFile, Collection<RepositoryLayout.Checksum> checksums) {
        HashSet<String> algos = new HashSet<String>();
        for (RepositoryLayout.Checksum checksum : checksums) {
            String algo = checksum.getAlgorithm();
            if (!algos.add(algo)) continue;
            this.checksums.add(new Checksum(algo));
        }
        this.targetFile = targetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(long dataOffset) {
        for (Checksum checksum : this.checksums) {
            checksum.reset();
        }
        if (dataOffset <= 0L) {
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.targetFile);
            long total = 0L;
            ByteBuffer buffer = ByteBuffer.allocate(32768);
            byte[] array2 = buffer.array();
            while (total < dataOffset) {
                int read2 = ((InputStream)in).read(array2);
                if (read2 < 0) {
                    if (total >= dataOffset) break;
                    throw new IOException(this.targetFile + " contains only " + total + " bytes, cannot resume download from offset " + dataOffset);
                }
                if ((total += (long)read2) > dataOffset) {
                    read2 = (int)((long)read2 - (total - dataOffset));
                }
                buffer.rewind();
                buffer.limit(read2);
                this.update(buffer);
            }
            ((InputStream)in).close();
            in = null;
        }
        catch (IOException e2) {
            for (Checksum checksum : this.checksums) {
                checksum.error(e2);
            }
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void update(ByteBuffer data2) {
        for (Checksum checksum : this.checksums) {
            data2.mark();
            checksum.update(data2);
            data2.reset();
        }
    }

    public Map<String, Object> get() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Checksum checksum : this.checksums) {
            results.put(checksum.algorithm, checksum.get());
        }
        return results;
    }

    static class Checksum {
        final String algorithm;
        final MessageDigest digest;
        Exception error;

        public Checksum(String algorithm) {
            this.algorithm = algorithm;
            MessageDigest digest = null;
            try {
                digest = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e2) {
                this.error = e2;
            }
            this.digest = digest;
        }

        public void update(ByteBuffer buffer) {
            if (this.digest != null) {
                this.digest.update(buffer);
            }
        }

        public void reset() {
            if (this.digest != null) {
                this.digest.reset();
                this.error = null;
            }
        }

        public void error(Exception error) {
            if (this.digest != null) {
                this.error = error;
            }
        }

        public Object get() {
            if (this.error != null) {
                return this.error;
            }
            return ChecksumUtils.toHexString(this.digest.digest());
        }
    }
}

