/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.parsers;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.builders.CircleBuilder;
import org.elasticsearch.common.geo.builders.GeometryCollectionBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.geo.parsers.CoordinateNode;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.GeoShapeFieldMapper;

abstract class GeoJsonParser {
    GeoJsonParser() {
    }

    protected static ShapeBuilder parse(XContentParser parser, GeoShapeFieldMapper shapeMapper) throws IOException {
        XContentParser.Token token;
        Enum shapeType = null;
        DistanceUnit.Distance radius = null;
        CoordinateNode coordinateNode = null;
        GeometryCollectionBuilder geometryCollections = null;
        ShapeBuilder.Orientation requestedOrientation = shapeMapper == null ? ShapeBuilder.Orientation.RIGHT : shapeMapper.fieldType().orientation();
        Explicit<Boolean> coerce = shapeMapper == null ? GeoShapeFieldMapper.Defaults.COERCE : shapeMapper.coerce();
        String malformedException = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String fieldName = parser.currentName();
            if (ShapeParser.FIELD_TYPE.match(fieldName)) {
                parser.nextToken();
                GeoShapeType type = GeoShapeType.forName(parser.text());
                if (shapeType != null && !shapeType.equals((Object)type)) {
                    malformedException = ShapeParser.FIELD_TYPE + " already parsed as [" + shapeType + "] cannot redefine as [" + (Object)((Object)type) + "]";
                    continue;
                }
                shapeType = type;
                continue;
            }
            if (ShapeParser.FIELD_COORDINATES.match(fieldName)) {
                parser.nextToken();
                coordinateNode = GeoJsonParser.parseCoordinates(parser);
                continue;
            }
            if (ShapeParser.FIELD_GEOMETRIES.match(fieldName)) {
                if (shapeType == null) {
                    shapeType = GeoShapeType.GEOMETRYCOLLECTION;
                } else if (!shapeType.equals((Object)GeoShapeType.GEOMETRYCOLLECTION)) {
                    malformedException = "cannot have [" + ShapeParser.FIELD_GEOMETRIES + "] with type set to [" + shapeType + "]";
                }
                parser.nextToken();
                geometryCollections = GeoJsonParser.parseGeometries(parser, shapeMapper);
                continue;
            }
            if (CircleBuilder.FIELD_RADIUS.match(fieldName)) {
                if (shapeType == null) {
                    shapeType = GeoShapeType.CIRCLE;
                } else if (shapeType != null && !shapeType.equals((Object)GeoShapeType.CIRCLE)) {
                    malformedException = "cannot have [" + CircleBuilder.FIELD_RADIUS + "] with type set to [" + shapeType + "]";
                }
                parser.nextToken();
                radius = DistanceUnit.Distance.parseDistance(parser.text());
                continue;
            }
            if (ShapeParser.FIELD_ORIENTATION.match(fieldName)) {
                if (shapeType != null && !(shapeType.equals((Object)GeoShapeType.POLYGON) || shapeType.equals((Object)GeoShapeType.MULTIPOLYGON))) {
                    malformedException = "cannot have [" + ShapeParser.FIELD_ORIENTATION + "] with type set to [" + shapeType + "]";
                }
                parser.nextToken();
                requestedOrientation = ShapeBuilder.Orientation.fromString(parser.text());
                continue;
            }
            parser.nextToken();
            parser.skipChildren();
        }
        if (malformedException != null) {
            throw new ElasticsearchParseException(malformedException, new Object[0]);
        }
        if (shapeType == null) {
            throw new ElasticsearchParseException("shape type not included", new Object[0]);
        }
        if (coordinateNode == null && GeoShapeType.GEOMETRYCOLLECTION != shapeType) {
            throw new ElasticsearchParseException("coordinates not included", new Object[0]);
        }
        if (geometryCollections == null && GeoShapeType.GEOMETRYCOLLECTION == shapeType) {
            throw new ElasticsearchParseException("geometries not included", new Object[0]);
        }
        if (radius != null && GeoShapeType.CIRCLE != shapeType) {
            throw new ElasticsearchParseException("field [{}] is supported for [{}] only", new Object[]{CircleBuilder.FIELD_RADIUS, CircleBuilder.TYPE});
        }
        if (shapeType == null) {
            throw new ElasticsearchParseException("shape type [{}] not included", shapeType);
        }
        if (shapeType.equals((Object)GeoShapeType.GEOMETRYCOLLECTION)) {
            return geometryCollections;
        }
        return ((GeoShapeType)shapeType).getBuilder(coordinateNode, radius, requestedOrientation, coerce.value());
    }

    private static CoordinateNode parseCoordinates(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_ARRAY && token != XContentParser.Token.END_ARRAY && token != XContentParser.Token.VALUE_NULL) {
            return new CoordinateNode(GeoJsonParser.parseCoordinate(parser));
        }
        if (token == XContentParser.Token.VALUE_NULL) {
            throw new IllegalArgumentException("coordinates cannot contain NULL values)");
        }
        ArrayList<CoordinateNode> nodes = new ArrayList<CoordinateNode>();
        while (token != XContentParser.Token.END_ARRAY) {
            nodes.add(GeoJsonParser.parseCoordinates(parser));
            token = parser.nextToken();
        }
        return new CoordinateNode(nodes);
    }

    private static Coordinate parseCoordinate(XContentParser parser) throws IOException {
        double lon = parser.doubleValue();
        parser.nextToken();
        double lat = parser.doubleValue();
        XContentParser.Token token = parser.nextToken();
        while (token == XContentParser.Token.VALUE_NUMBER) {
            token = parser.nextToken();
        }
        return new Coordinate(lon, lat);
    }

    static GeometryCollectionBuilder parseGeometries(XContentParser parser, GeoShapeFieldMapper mapper) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("geometries must be an array of geojson objects", new Object[0]);
        }
        XContentParser.Token token = parser.nextToken();
        GeometryCollectionBuilder geometryCollection = new GeometryCollectionBuilder();
        while (token != XContentParser.Token.END_ARRAY) {
            ShapeBuilder shapeBuilder = ShapeParser.parse(parser);
            geometryCollection.shape(shapeBuilder);
            token = parser.nextToken();
        }
        return geometryCollection;
    }
}

