/* gnome-games.vapi generated by valac 0.38.2, do not modify. */

namespace Games {
	namespace Credits {
	}
	namespace Fingerprint {
	}
	namespace Grep {
		[CCode (cheader_filename = "libgnome-games.h")]
		public static size_t[] get_offsets (string filename, string text);
	}
	namespace RetroPlatform {
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class Application : Gtk.Application {
		protected override void activate ();
		public void add_game_files ();
		public async void add_game_files_async ();
		public static string get_cache_dir ();
		public static string get_config_dir ();
		public static string get_covers_dir ();
		public static string get_data_dir ();
		public static string get_database_path ();
		public static string get_medias_dir ();
		public static string get_platforms_dir ();
		public static string get_saves_dir ();
		public static string get_snapshots_dir ();
		protected override void open (GLib.File[] files, string hint);
		public static void try_make_dir (string path);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class CommandRunner : GLib.Object, Games.Runner {
		public CommandRunner (string[] args, bool watch_child);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class CompositeCover : GLib.Object, Games.Cover {
		public CompositeCover (Games.Cover[] covers);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class CompositeTitle : GLib.Object, Games.Title {
		public CompositeTitle (Games.Title[] titles);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class CueSheet : GLib.Object {
		public CueSheet (GLib.File file) throws GLib.Error;
		public Games.CueSheetTrackNode get_track (uint i) throws GLib.Error;
		public GLib.File file { get; }
		public uint tracks_number { get; }
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class CueSheetFileNode : GLib.Object {
		public CueSheetFileNode (GLib.File file, Games.CueSheetFileFormat file_format);
		public GLib.File file { get; construct; }
		public Games.CueSheetFileFormat file_format { get; construct; }
		public string file_name { get; construct; }
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class CueSheetTrackNode : GLib.Object {
		public CueSheetTrackNode (Games.CueSheetFileNode file, int track_number, Games.CueSheetTrackMode track_mode);
		public Games.CueSheetFileNode file { get; construct; }
		public Games.CueSheetTrackMode track_mode { get; construct; }
		public int track_number { get; construct; }
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class Directory : GLib.Object {
		public delegate bool FileInfoTest (GLib.FileInfo file_info) throws GLib.Error;
		public Directory (GLib.File file);
		public void @foreach (string attributes, Games.Directory.FileInfoTest file_info_test) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class DummyCover : GLib.Object, Games.Cover {
		public DummyCover ();
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class DummyIcon : GLib.Object, Games.Icon {
		public DummyIcon ();
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class FilenameTitle : GLib.Object, Games.Title {
		public FilenameTitle (Games.Uri uri);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class FingerprintUid : GLib.Object, Games.Uid {
		public FingerprintUid (Games.Uri uri, string prefix);
		public FingerprintUid.for_chunk (Games.Uri uri, string prefix, size_t start, size_t length);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class GameinfoDiscIdDiscTitle : GLib.Object, Games.Title {
		public GameinfoDiscIdDiscTitle (Games.GameinfoDoc gameinfo, string disc_id, string? domain = null);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class GameinfoDiscIdGameTitle : GLib.Object, Games.Title {
		public GameinfoDiscIdGameTitle (Games.GameinfoDoc gameinfo, string disc_id, string? domain = null);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class GameinfoDiscIdInputCapabilities : GLib.Object, Games.InputCapabilities {
		public GameinfoDiscIdInputCapabilities (Games.GameinfoDoc gameinfo, string disc_id);
		public bool default_allow_analog_gamepads { get; set; }
		public bool default_allow_classic_gamepads { get; set; }
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class GameinfoDoc : GLib.Object {
		public GameinfoDoc ();
		public GameinfoDoc.from_data (uint8[] data) throws GLib.Error;
		public string? get_disc_set_id_for_disc_id (string disc_id) throws GLib.Error;
		public string[] get_disc_set_ids_for_disc_id (string disc_id) throws GLib.Error;
		public int get_disc_set_index_for_disc_id (string disc_id) throws GLib.Error;
		public int get_disc_set_size_for_disc_id (string disc_id) throws GLib.Error;
		public string? get_disc_title_for_disc_id (string disc_id) throws GLib.Error;
		public string[] get_game_controllers_for_disc_id (string disc_id) throws GLib.Error;
		public string? get_game_title_for_disc_id (string disc_id) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class GenericGame : GLib.Object, Games.Game {
		public GenericGame (Games.Title title, Games.Icon icon, Games.Cover cover, Games.Runner runner);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class GenericGameUriAdapter : Games.GameUriAdapter, GLib.Object {
		public delegate Games.Game GameForUri (Games.Uri uri) throws GLib.Error;
		public GenericGameUriAdapter (owned Games.GenericGameUriAdapter.GameForUri callback);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class GenericTitle : GLib.Object, Games.Title {
		public GenericTitle (string title);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class GenericUid : GLib.Object, Games.Uid {
		public GenericUid (string uid);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class GenericUriGameFactory : GLib.Object, Games.UriGameFactory {
		public GenericUriGameFactory (Games.GameUriAdapter game_uri_adapter);
		public void add_mime_type (string mime_type);
		public void add_scheme (string scheme);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class GriloCover : GLib.Object, Games.Cover {
		public GriloCover (Games.GriloMedia media, Games.Uid uid);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class GriloMedia : GLib.Object {
		public GriloMedia (Games.Title title, string mime_type);
		public void try_resolve_media ();
		public signal void resolved ();
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class LocalCover : GLib.Object, Games.Cover {
		public LocalCover (Games.Uri uri);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class Media : GLib.Object {
		public Media (Games.Title? title = null);
		public void add_uri (Games.Uri uri);
		public Games.MediaInfo get_media_info ();
		public Games.Uri[] get_uris ();
		public Games.Title? title { get; private set; }
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class MediaInfo : GLib.Object {
		public MediaInfo (string platform, string game_id, string? media_id, uint media_index);
		public string game_id { get; private set; }
		public string? media_id { get; private set; }
		public uint media_index { get; private set; }
		public string platform { get; private set; }
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class MediaSet : GLib.Object {
		public delegate void MediaCallback (Games.Media media);
		public MediaSet ();
		public void add_media (Games.Media media);
		public void foreach_media (Games.MediaSet.MediaCallback media_callback);
		public Games.Media get_selected_media (uint index) throws GLib.Error;
		public int get_size ();
		public GLib.Icon? icon { get; set; }
		public int selected_media_number { get; set; }
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class MimeTypeTrackerUriQuery : GLib.Object, Games.TrackerUriQuery {
		public MimeTypeTrackerUriQuery (string mime_type);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	[GtkTemplate (ui = "/org/gnome/Games/ui/remote-display.ui")]
	public class RemoteDisplay : Gtk.Box {
		public RemoteDisplay ();
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	[GtkTemplate (ui = "/org/gnome/Games/ui/reset-gamepad-mapping-dialog.ui")]
	public class ResetGamepadMappingDialog : Gtk.MessageDialog {
		public ResetGamepadMappingDialog ();
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class RetroCoreSource : GLib.Object {
		public RetroCoreSource (string platform, string[] mime_types);
		public string get_module_path () throws GLib.Error;
		public string get_platform ();
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class RetroRunner : GLib.Object, Games.Runner {
		public RetroRunner (Games.RetroCoreSource core_source, Games.Uri uri, Games.Uid uid, Games.Title game_title);
		public RetroRunner.for_core_descriptor (Retro.CoreDescriptor core_descriptor, Games.Uid uid, Games.Title game_title);
		public RetroRunner.for_media_set_and_input_capabilities (Games.RetroCoreSource core_source, Games.MediaSet media_set, Games.Uid uid, Games.InputCapabilities input_capabilities, Games.Title game_title);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class StringInputStream : GLib.Object {
		public StringInputStream (GLib.File file);
		public bool has_string (size_t offset, string value) throws GLib.Error;
		public string read_string (size_t offset) throws GLib.Error;
		public string read_string_for_size (size_t offset, size_t size) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class TrackerUriSource : GLib.Object, Games.UriSource {
		public TrackerUriSource (Tracker.Sparql.Connection connection);
		public void add_query (Games.TrackerUriQuery query);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public class Uri {
		public Uri (string uri);
		public static bool equal (Games.Uri a, Games.Uri b);
		public Uri.from_file (GLib.File file);
		public Uri.from_uri_and_scheme (Games.Uri uri, string scheme) throws GLib.Error;
		public string get_scheme () throws GLib.Error;
		public static uint hash (Games.Uri uri);
		public GLib.File to_file ();
		public string to_string ();
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public interface Cover : GLib.Object {
		public abstract GLib.Icon? get_cover ();
		public signal void changed ();
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public interface Game : GLib.Object {
		public abstract Games.Cover get_cover ();
		public abstract Games.Icon get_icon ();
		public abstract Games.Runner get_runner () throws GLib.Error;
		public abstract string name { get; }
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public interface GameUriAdapter : GLib.Object {
		public abstract async Games.Game game_for_uri (Games.Uri uri) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public interface Icon : GLib.Object {
		public abstract GLib.Icon? get_icon ();
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public interface InputCapabilities : GLib.Object {
		public abstract bool get_allow_analog_gamepads () throws GLib.Error;
		public abstract bool get_allow_classic_gamepads () throws GLib.Error;
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public interface Plugin : GLib.Object {
		public virtual string[] get_mime_types ();
		public virtual Games.UriGameFactory[] get_uri_game_factories ();
		public virtual Games.UriSource[] get_uri_sources ();
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public interface Runner : GLib.Object {
		public abstract bool check_is_valid (out string error_message) throws GLib.Error;
		public abstract Gtk.Widget get_display ();
		public abstract void pause ();
		public abstract void resume () throws GLib.Error;
		public abstract void start () throws GLib.Error;
		public abstract void stop ();
		public abstract bool can_fullscreen { get; }
		public abstract bool can_quit_safely { get; }
		public abstract bool can_resume { get; }
		public abstract Games.MediaSet? media_set { get; }
		public signal void stopped ();
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public interface Title : GLib.Object {
		public abstract string get_title () throws GLib.Error;
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public interface TrackerUriQuery : GLib.Object {
		public abstract string get_query ();
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public interface Uid : GLib.Object {
		public abstract string get_uid () throws GLib.Error;
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public interface UriGameFactory : GLib.Object {
		public abstract async void add_uri (Games.Uri uri);
		public abstract async void foreach_game (Games.GameCallback game_callback);
		public virtual string[] get_mime_types ();
		public virtual string[] get_schemes ();
		public abstract async Games.Game? query_game_for_uri (Games.Uri uri);
		public signal void game_added (Games.Game game);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public interface UriIterator : GLib.Object {
		public abstract new Games.Uri? @get ();
		public abstract bool next ();
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public interface UriSource : GLib.Object {
		public abstract Games.UriIterator iterator ();
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public enum CueSheetFileFormat {
		INVALID,
		AIFF,
		BINARY,
		MOTOROLA,
		MP3,
		VORBIS,
		WAVE,
		UNKNOWN;
		public static Games.CueSheetFileFormat parse_string (string? value);
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public enum CueSheetTrackMode {
		INVALID,
		AUDIO,
		CDG,
		MODE1_2048,
		MODE1_2352,
		MODE2_2336,
		MODE2_2352,
		CDI_2336,
		CDI_2352;
		public static Games.CueSheetTrackMode parse_string (string value);
		public bool is_mode1 ();
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public errordomain CommandError {
		INVALID_COMMAND,
		EXECUTION_FAILED
	}
	[CCode (cheader_filename = "libgnome-games.h")]
	public delegate void GameCallback (Games.Game game);
}
[CCode (cheader_filename = "libgnome-games.h")]
public errordomain TrackerError {
	FILE_NOT_FOUND
}
