/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;

public class XmlMessageRenderer
implements MessageRenderer {
    @Override
    public String renderPreamble() {
        return "<MESSAGES>";
    }

    @Override
    public String render(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageLocation location2) {
        StringBuilder out = new StringBuilder();
        String tagName = severity.getPresentableName();
        out.append("<").append(tagName);
        if (location2 != null) {
            out.append(" path=\"").append(XmlMessageRenderer.e(location2.getPath())).append("\"");
            out.append(" line=\"").append(location2.getLine()).append("\"");
            out.append(" column=\"").append(location2.getColumn()).append("\"");
        }
        out.append(">");
        out.append(XmlMessageRenderer.e(message));
        out.append("</").append(tagName).append(">\n");
        return out.toString();
    }

    private static String e(String str) {
        return StringUtil.escapeXml(str);
    }

    @Override
    public String renderUsage(@NotNull String usage) {
        return this.render(CompilerMessageSeverity.STRONG_WARNING, usage, null);
    }

    @Override
    public String renderConclusion() {
        return "</MESSAGES>";
    }
}

