/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;

public abstract class PsiReferenceService {
    public static final Key<Hints> HINTS = Key.create("HINTS");

    public static PsiReferenceService getService() {
        return ServiceManager.getService(PsiReferenceService.class);
    }

    @NotNull
    public abstract List<PsiReference> getReferences(@NotNull PsiElement var1, @NotNull Hints var2);

    @NotNull
    public PsiReference[] getContributedReferences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/PsiReferenceService", "getContributedReferences"));
        }
        List<PsiReference> list2 = this.getReferences(element, Hints.NO_HINTS);
        PsiReference[] psiReferenceArray = list2.toArray(new PsiReference[list2.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiReferenceService", "getContributedReferences"));
        }
        return psiReferenceArray;
    }

    public static class Hints {
        public static final Hints NO_HINTS = new Hints();
        @Nullable
        public final PsiElement target;
        @Nullable
        public final Integer offsetInElement;

        public Hints() {
            this.target = null;
            this.offsetInElement = null;
        }

        public Hints(@Nullable PsiElement target, @Nullable Integer offsetInElement) {
            this.target = target;
            this.offsetInElement = offsetInElement;
        }
    }
}

