/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModuleReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackageAccessibilityStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiProvidesStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRequiresStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiUsesStatement;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsJavaModuleReferenceElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaModuleStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;

public class ClsJavaModuleImpl
extends ClsRepositoryPsiElement<PsiJavaModuleStub>
implements PsiJavaModule {
    private final PsiJavaModuleReferenceElement myReference;

    public ClsJavaModuleImpl(PsiJavaModuleStub stub) {
        super(stub);
        this.myReference = new ClsJavaModuleReferenceElementImpl(this, stub.getName());
    }

    @Override
    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        JBIterable<PsiElement> jBIterable = JBIterable.of(((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.REQUIRES_STATEMENT, PsiRequiresStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getRequires"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getExports() {
        JBIterable<PsiElement> jBIterable = JBIterable.of(((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.EXPORTS_STATEMENT, PsiPackageAccessibilityStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getExports"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getOpens() {
        JBIterable<PsiElement> jBIterable = JBIterable.of(((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.OPENS_STATEMENT, PsiPackageAccessibilityStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getOpens"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public Iterable<PsiUsesStatement> getUses() {
        JBIterable<PsiElement> jBIterable = JBIterable.of(((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.USES_STATEMENT, PsiUsesStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getUses"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public Iterable<PsiProvidesStatement> getProvides() {
        JBIterable<PsiElement> jBIterable = JBIterable.of(((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.PROVIDES_STATEMENT, PsiProvidesStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getProvides"));
        }
        return jBIterable;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "appendMirrorText"));
        }
        ClsJavaModuleImpl.appendText(this.getModifierList(), indentLevel, buffer);
        buffer.append("module ").append(this.getName()).append(" {\n");
        int newIndentLevel = indentLevel + this.getIndentSize();
        int start = buffer.length();
        ClsJavaModuleImpl.appendChildren(this.getRequires(), buffer, newIndentLevel, start);
        ClsJavaModuleImpl.appendChildren(this.getExports(), buffer, newIndentLevel, start);
        ClsJavaModuleImpl.appendChildren(this.getOpens(), buffer, newIndentLevel, start);
        ClsJavaModuleImpl.appendChildren(this.getUses(), buffer, newIndentLevel, start);
        ClsJavaModuleImpl.appendChildren(this.getProvides(), buffer, newIndentLevel, start);
        StringUtil.repeatSymbol(buffer, ' ', indentLevel);
        buffer.append('}');
    }

    private static void appendChildren(Iterable<? extends PsiElement> children, StringBuilder buffer, int indentLevel, int start) {
        ArrayList<? extends PsiElement> statements = ContainerUtil.newArrayList(children);
        if (!statements.isEmpty()) {
            if (buffer.length() > start) {
                buffer.append('\n');
            }
            for (PsiElement psiElement : statements) {
                ClsJavaModuleImpl.appendText(psiElement, indentLevel, buffer);
            }
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, JavaElementType.MODULE);
        PsiJavaModule mirror = (PsiJavaModule)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsJavaModuleImpl.setMirror(this.getNameIdentifier(), mirror.getNameIdentifier());
        ClsJavaModuleImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsJavaModuleImpl.setMirrors(this.getRequires(), mirror.getRequires());
        ClsJavaModuleImpl.setMirrors(this.getExports(), mirror.getExports());
        ClsJavaModuleImpl.setMirrors(this.getOpens(), mirror.getOpens());
        ClsJavaModuleImpl.setMirrors(this.getUses(), mirror.getUses());
        ClsJavaModuleImpl.setMirrors(this.getProvides(), mirror.getProvides());
    }

    private static <T extends PsiElement> void setMirrors(Iterable<T> stubs, Iterable<T> mirrors) {
        ClsJavaModuleImpl.setMirrors(ContainerUtil.newArrayList(stubs), ContainerUtil.newArrayList(mirrors));
    }

    @Override
    @NotNull
    public PsiJavaModuleReferenceElement getNameIdentifier() {
        PsiJavaModuleReferenceElement psiJavaModuleReferenceElement = this.myReference;
        if (psiJavaModuleReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getNameIdentifier"));
        }
        return psiJavaModuleReferenceElement;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myReference.getReferenceText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getName"));
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "setName"));
        }
        throw ClsJavaModuleImpl.cannotModifyException(this);
    }

    @Override
    public PsiModifierList getModifierList() {
        StubElement<PsiModifierList> childStub = ((PsiJavaModuleStub)this.getStub()).findChildStubByType(JavaStubElementTypes.MODIFIER_LIST);
        return childStub != null ? childStub.getPsi() : null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "hasModifierProperty"));
        }
        PsiModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty(name);
    }

    @Override
    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiJavaModuleReferenceElement psiJavaModuleReferenceElement = this.getNameIdentifier();
        if (psiJavaModuleReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getNavigationElement"));
        }
        return psiJavaModuleReferenceElement;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitModule(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiJavaModule:" + this.getName();
    }
}

