/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl;

import org.jetbrains.kotlin.com.intellij.codeInsight.AnnotationUtil;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiElementFactoryImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.CharTableImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiAnnotationStubImpl
extends StubBase<PsiAnnotation>
implements PsiAnnotationStub {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl");
    private final String myText;
    private SoftReference<PsiAnnotation> myParsedFromRepository;

    public PsiAnnotationStubImpl(StubElement parent2, String text2) {
        super(parent2, JavaStubElementTypes.ANNOTATION);
        CharSequence interned = CharTableImpl.getStaticInterned(text2);
        this.myText = interned == null ? text2 : interned.toString();
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public PsiAnnotation getPsiElement() {
        PsiAnnotation annotation2 = SoftReference.dereference(this.myParsedFromRepository);
        if (annotation2 != null) {
            return annotation2;
        }
        String text2 = this.getText();
        try {
            PsiJavaParserFacade facade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
            annotation2 = facade instanceof PsiElementFactoryImpl ? ((PsiElementFactoryImpl)facade).createAnnotationFromText(text2, (PsiElement)this.getPsi(), false) : facade.createAnnotationFromText(text2, (PsiElement)this.getPsi());
            this.myParsedFromRepository = new SoftReference<PsiAnnotation>(annotation2);
            return annotation2;
        }
        catch (IncorrectOperationException e) {
            LOG.error("Bad annotation in " + this.fileName(), e);
            return null;
        }
    }

    private String fileName() {
        StubElement<PsiAnnotation> stub = this;
        while ((stub = stub.getParentStub()) != null) {
            PsiAnnotation psi;
            if (!(stub instanceof PsiFileStub) || !((psi = stub.getPsi()) instanceof PsiFile)) continue;
            VirtualFile file = ((PsiFile)((Object)psi)).getVirtualFile();
            return file != null ? file.getUrl() : ((PsiFile)((Object)psi)).getName();
        }
        return "<unknown file>";
    }

    @Override
    public String toString() {
        return "PsiAnnotationStub[" + this.myText + ']';
    }

    static {
        CharTableImpl.addStringsFromClassToStatics(AnnotationUtil.class);
        CharTableImpl.staticIntern("@NotNull");
        CharTableImpl.staticIntern("@Nullable");
        CharTableImpl.staticIntern("@Override");
    }
}

