/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModuleReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackageAccessibilityStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiProvidesStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRequiresStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiUsesStatement;
import org.jetbrains.kotlin.com.intellij.psi.SyntaxTraverser;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaModuleStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaStubPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;

public class PsiJavaModuleImpl
extends JavaStubPsiElement<PsiJavaModuleStub>
implements PsiJavaModule {
    public PsiJavaModuleImpl(@NotNull PsiJavaModuleStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "<init>"));
        }
        super(stub, JavaStubElementTypes.MODULE);
    }

    public PsiJavaModuleImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        PsiJavaModuleStub stub = (PsiJavaModuleStub)this.getGreenStub();
        if (stub != null) {
            JBIterable<PsiElement> jBIterable = JBIterable.of(stub.getChildrenByType(JavaElementType.REQUIRES_STATEMENT, PsiRequiresStatement.EMPTY_ARRAY));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "getRequires"));
            }
            return jBIterable;
        }
        JBIterable<PsiRequiresStatement> jBIterable = SyntaxTraverser.psiTraverser().children(this).filter(PsiRequiresStatement.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "getRequires"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getExports() {
        PsiJavaModuleStub stub = (PsiJavaModuleStub)this.getGreenStub();
        if (stub != null) {
            JBIterable<PsiElement> jBIterable = JBIterable.of(stub.getChildrenByType(JavaElementType.EXPORTS_STATEMENT, PsiPackageAccessibilityStatement.EMPTY_ARRAY));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "getExports"));
            }
            return jBIterable;
        }
        JBIterable<PsiPackageAccessibilityStatement> jBIterable = SyntaxTraverser.psiTraverser().children(this).filter(PsiPackageAccessibilityStatement.class).filter(statement2 -> statement2.getRole() == PsiPackageAccessibilityStatement.Role.EXPORTS);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "getExports"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getOpens() {
        PsiJavaModuleStub stub = (PsiJavaModuleStub)this.getGreenStub();
        if (stub != null) {
            JBIterable<PsiElement> jBIterable = JBIterable.of(stub.getChildrenByType(JavaElementType.OPENS_STATEMENT, PsiPackageAccessibilityStatement.EMPTY_ARRAY));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "getOpens"));
            }
            return jBIterable;
        }
        JBIterable<PsiPackageAccessibilityStatement> jBIterable = SyntaxTraverser.psiTraverser().children(this).filter(PsiPackageAccessibilityStatement.class).filter(statement2 -> statement2.getRole() == PsiPackageAccessibilityStatement.Role.OPENS);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "getOpens"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public Iterable<PsiUsesStatement> getUses() {
        JBIterable<PsiUsesStatement> jBIterable = SyntaxTraverser.psiTraverser().children(this).filter(PsiUsesStatement.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "getUses"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public Iterable<PsiProvidesStatement> getProvides() {
        JBIterable<PsiProvidesStatement> jBIterable = SyntaxTraverser.psiTraverser().children(this).filter(PsiProvidesStatement.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "getProvides"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public PsiJavaModuleReferenceElement getNameIdentifier() {
        PsiJavaModuleReferenceElement psiJavaModuleReferenceElement = PsiTreeUtil.getRequiredChildOfType(this, PsiJavaModuleReferenceElement.class);
        if (psiJavaModuleReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "getNameIdentifier"));
        }
        return psiJavaModuleReferenceElement;
    }

    @Override
    @NotNull
    public String getName() {
        PsiJavaModuleStub stub = (PsiJavaModuleStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "getName"));
            }
            return string;
        }
        String string = this.getNameIdentifier().getReferenceText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "getName"));
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "setName"));
        }
        PsiElementFactory factory2 = PsiElementFactory.SERVICE.getInstance(this.getProject());
        PsiJavaModuleReferenceElement newName2 = factory2.createModuleFromText("module " + name + " {}").getNameIdentifier();
        this.getNameIdentifier().replace(newName2);
        return this;
    }

    @Override
    public PsiModifierList getModifierList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "hasModifierProperty"));
        }
        PsiModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty(name);
    }

    @Override
    @Nullable
    public PsiDocComment getDocComment() {
        return PsiTreeUtil.getChildOfType(this, PsiDocComment.class);
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public int getTextOffset() {
        return this.getNameIdentifier().getTextOffset();
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiJavaModuleReferenceElement psiJavaModuleReferenceElement = this.getNameIdentifier();
        if (psiJavaModuleReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "getNavigationElement"));
        }
        return psiJavaModuleReferenceElement;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitModule(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiJavaModule:" + this.getName();
    }
}

