/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.ModificationTracker;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;

public interface PsiModificationTracker
extends ModificationTracker {
    public static final Key MODIFICATION_COUNT = Key.create("MODIFICATION_COUNT");
    public static final Key OUT_OF_CODE_BLOCK_MODIFICATION_COUNT = Key.create("OUT_OF_CODE_BLOCK_MODIFICATION_COUNT");
    public static final Key JAVA_STRUCTURE_MODIFICATION_COUNT = Key.create("JAVA_STRUCTURE_MODIFICATION_COUNT");
    public static final Topic<Listener> TOPIC = new Topic<Listener>("modification tracker", Listener.class, Topic.BroadcastDirection.TO_PARENT);

    @Override
    public long getModificationCount();

    public long getOutOfCodeBlockModificationCount();

    @NotNull
    public ModificationTracker getOutOfCodeBlockModificationTracker();

    public long getJavaStructureModificationCount();

    @NotNull
    public ModificationTracker getJavaStructureModificationTracker();

    public static interface Listener {
        public void modificationCountChanged();
    }

    public static class SERVICE {
        private SERVICE() {
        }

        public static PsiModificationTracker getInstance(Project project) {
            return ServiceManager.getService(project, PsiModificationTracker.class);
        }
    }
}

