/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.ParameterizedCachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.ParameterizedCachedValueProvider;
import org.jetbrains.kotlin.com.intellij.util.CachedValueBase;
import org.jetbrains.kotlin.com.intellij.util.CachedValueLeakChecker;
import org.jetbrains.kotlin.com.intellij.util.CachedValuesFactory;
import org.jetbrains.kotlin.com.intellij.util.DefaultCachedValuesFactory;

public class CachedValuesManagerImpl
extends CachedValuesManager {
    private final Project myProject;
    private final CachedValuesFactory myFactory;

    public CachedValuesManagerImpl(Project project, CachedValuesFactory factory2) {
        this.myProject = project;
        this.myFactory = factory2 == null ? new DefaultCachedValuesFactory(project) : factory2;
    }

    @Override
    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/util/CachedValuesManagerImpl", "createCachedValue"));
        }
        CachedValue<T> cachedValue2 = this.myFactory.createCachedValue(provider, trackValue);
        if (cachedValue2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/CachedValuesManagerImpl", "createCachedValue"));
        }
        return cachedValue2;
    }

    @Override
    @NotNull
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/util/CachedValuesManagerImpl", "createParameterizedCachedValue"));
        }
        ParameterizedCachedValue<T, P> parameterizedCachedValue = this.myFactory.createParameterizedCachedValue(provider, trackValue);
        if (parameterizedCachedValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/CachedValuesManagerImpl", "createParameterizedCachedValue"));
        }
        return parameterizedCachedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T, D extends UserDataHolder> T getCachedValue(@NotNull D dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        CachedValue<T> value;
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "org/jetbrains/kotlin/com/intellij/util/CachedValuesManagerImpl", "getCachedValue"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/util/CachedValuesManagerImpl", "getCachedValue"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/util/CachedValuesManagerImpl", "getCachedValue"));
        }
        CachedValueLeakChecker.checkProvider(provider, key, dataHolder);
        if (dataHolder instanceof UserDataHolderEx) {
            UserDataHolderEx dh = (UserDataHolderEx)dataHolder;
            value = dh.getUserData(key);
            while (this.isOutdated(value)) {
                if (dh.replace(key, value, null)) {
                    value = null;
                    break;
                }
                value = dh.getUserData(key);
            }
            if (value == null) {
                value = this.createCachedValue(provider, trackValue);
                assert (((CachedValueBase)((Object)value)).isFromMyProject(this.myProject));
                value = dh.putUserDataIfAbsent(key, value);
            }
        } else {
            D d = dataHolder;
            synchronized (d) {
                value = dataHolder.getUserData(key);
                if (this.isOutdated(value)) {
                    value = null;
                }
                if (value == null) {
                    value = this.createCachedValue(provider, trackValue);
                    dataHolder.putUserData(key, value);
                }
            }
        }
        return value.getValue();
    }

    private boolean isOutdated(CachedValue<?> value) {
        return value instanceof CachedValueBase && (!((CachedValueBase)((Object)value)).isFromMyProject(this.myProject) || CachedValuesManagerImpl.hasOutdatedValue((CachedValueBase)((Object)value)));
    }

    private static boolean hasOutdatedValue(CachedValueBase base) {
        return !base.hasUpToDateValue() && base.getRawData() != null;
    }
}

