/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.impl.JavaSdkUtil;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020'0<2\u0006\u0010=\u001a\u00020'H\u0007J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020'0<H\u0007J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020'0<2\u0006\u0010@\u001a\u00020\u0004H\u0007J\u0014\u0010A\u001a\u00020'2\n\u0010B\u001a\u0006\u0012\u0002\b\u00030CH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u00198\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010 \u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001bR\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010+R\u001a\u0010.\u001a\u00020/8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b0\u0010\u0002\u001a\u0004\b1\u00102R\u001a\u00103\u001a\u00020/8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b4\u0010\u0002\u001a\u0004\b5\u00102R\u001a\u00106\u001a\u00020/8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b7\u0010\u0002\u001a\u0004\b8\u00102R\u0011\u00109\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010+\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/utils/PathUtil;", "", "()V", "ALLOPEN_PLUGIN_JAR_NAME", "", "HOME_FOLDER_NAME", "JS_LIB_10_JAR_NAME", "JS_LIB_JAR_NAME", "JS_LIB_SRC_JAR_NAME", "KOTLIN_COMPILER", "KOTLIN_COMPILER_JAR", "KOTLIN_JAVA_REFLECT_JAR", "KOTLIN_JAVA_RUNTIME_JDK7_JAR", "KOTLIN_JAVA_RUNTIME_JDK7_SRC_JAR", "KOTLIN_JAVA_RUNTIME_JDK8_JAR", "KOTLIN_JAVA_RUNTIME_JDK8_SRC_JAR", "KOTLIN_JAVA_RUNTIME_JRE7_JAR", "KOTLIN_JAVA_RUNTIME_JRE7_SRC_JAR", "KOTLIN_JAVA_RUNTIME_JRE8_JAR", "KOTLIN_JAVA_RUNTIME_JRE8_SRC_JAR", "KOTLIN_JAVA_SCRIPT_RUNTIME_JAR", "KOTLIN_JAVA_STDLIB_JAR", "KOTLIN_JAVA_STDLIB_SRC_JAR", "KOTLIN_JAVA_STDLIB_SRC_JAR_OLD", "KOTLIN_JS_LIBRARY_JAR_PATTERN", "Ljava/util/regex/Pattern;", "getKOTLIN_JS_LIBRARY_JAR_PATTERN", "()Ljava/util/regex/Pattern;", "KOTLIN_REFLECT_SRC_JAR", "KOTLIN_RUNTIME_JAR_PATTERN", "KOTLIN_STDLIB_COMMON_JAR_PATTERN", "getKOTLIN_STDLIB_COMMON_JAR_PATTERN", "KOTLIN_STDLIB_JS_JAR_PATTERN", "getKOTLIN_STDLIB_JS_JAR_PATTERN", "KOTLIN_TEST_JAR", "KOTLIN_TEST_JS_JAR", "KOTLIN_TEST_SRC_JAR", "NOARG_PLUGIN_JAR_NAME", "NO_PATH", "Ljava/io/File;", "SAM_WITH_RECEIVER_PLUGIN_JAR_NAME", "compilerPathForCompilerJar", "getCompilerPathForCompilerJar", "()Ljava/io/File;", "compilerPathForIdeaPlugin", "getCompilerPathForIdeaPlugin", "kotlinPathsForCompiler", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "kotlinPathsForCompiler$annotations", "getKotlinPathsForCompiler", "()Lorg/jetbrains/kotlin/utils/KotlinPaths;", "kotlinPathsForDistDirectory", "kotlinPathsForDistDirectory$annotations", "getKotlinPathsForDistDirectory", "kotlinPathsForIdeaPlugin", "kotlinPathsForIdeaPlugin$annotations", "getKotlinPathsForIdeaPlugin", "pathUtilJar", "getPathUtilJar", "getJdkClassesRoots", "", "jdkHome", "getJdkClassesRootsFromCurrentJre", "getJdkClassesRootsFromJre", "javaHome", "getResourcePathForClass", "aClass", "Ljava/lang/Class;", "util"})
public final class PathUtil {
    @NotNull
    public static final String JS_LIB_JAR_NAME = "kotlin-stdlib-js.jar";
    @NotNull
    public static final String JS_LIB_10_JAR_NAME = "kotlin-jslib.jar";
    @NotNull
    public static final String ALLOPEN_PLUGIN_JAR_NAME = "allopen-compiler-plugin.jar";
    @NotNull
    public static final String NOARG_PLUGIN_JAR_NAME = "noarg-compiler-plugin.jar";
    @NotNull
    public static final String SAM_WITH_RECEIVER_PLUGIN_JAR_NAME = "sam-with-receiver-compiler-plugin.jar";
    @NotNull
    public static final String JS_LIB_SRC_JAR_NAME = "kotlin-stdlib-js-sources.jar";
    @NotNull
    public static final String KOTLIN_JAVA_RUNTIME_JRE7_JAR = "kotlin-stdlib-jre7.jar";
    @NotNull
    public static final String KOTLIN_JAVA_RUNTIME_JDK7_JAR = "kotlin-stdlib-jdk7.jar";
    @NotNull
    public static final String KOTLIN_JAVA_RUNTIME_JRE8_JAR = "kotlin-stdlib-jre8.jar";
    @NotNull
    public static final String KOTLIN_JAVA_RUNTIME_JDK8_JAR = "kotlin-stdlib-jdk8.jar";
    @NotNull
    public static final String KOTLIN_JAVA_RUNTIME_JRE7_SRC_JAR = "kotlin-stdlib-jre7-sources.jar";
    @NotNull
    public static final String KOTLIN_JAVA_RUNTIME_JDK7_SRC_JAR = "kotlin-stdlib-jdk7-sources.jar";
    @NotNull
    public static final String KOTLIN_JAVA_RUNTIME_JRE8_SRC_JAR = "kotlin-stdlib-jre8-sources.jar";
    @NotNull
    public static final String KOTLIN_JAVA_RUNTIME_JDK8_SRC_JAR = "kotlin-stdlib-jdk8-sources.jar";
    @NotNull
    public static final String KOTLIN_JAVA_STDLIB_JAR = "kotlin-stdlib.jar";
    @NotNull
    public static final String KOTLIN_JAVA_REFLECT_JAR = "kotlin-reflect.jar";
    @NotNull
    public static final String KOTLIN_JAVA_SCRIPT_RUNTIME_JAR = "kotlin-script-runtime.jar";
    @NotNull
    public static final String KOTLIN_TEST_JAR = "kotlin-test.jar";
    @NotNull
    public static final String KOTLIN_TEST_JS_JAR = "kotlin-test-js.jar";
    @NotNull
    public static final String KOTLIN_JAVA_STDLIB_SRC_JAR = "kotlin-stdlib-sources.jar";
    @NotNull
    public static final String KOTLIN_JAVA_STDLIB_SRC_JAR_OLD = "kotlin-runtime-sources.jar";
    @NotNull
    public static final String KOTLIN_REFLECT_SRC_JAR = "kotlin-reflect-sources.jar";
    @NotNull
    public static final String KOTLIN_TEST_SRC_JAR = "kotlin-test-sources.jar";
    @NotNull
    public static final String KOTLIN_COMPILER = "kotlin-compiler";
    @NotNull
    public static final String KOTLIN_COMPILER_JAR = "kotlin-compiler.jar";
    @JvmField
    @NotNull
    public static final Pattern KOTLIN_RUNTIME_JAR_PATTERN;
    @NotNull
    private static final Pattern KOTLIN_STDLIB_JS_JAR_PATTERN;
    @NotNull
    private static final Pattern KOTLIN_STDLIB_COMMON_JAR_PATTERN;
    @NotNull
    private static final Pattern KOTLIN_JS_LIBRARY_JAR_PATTERN;
    @NotNull
    public static final String HOME_FOLDER_NAME = "kotlinc";
    private static final File NO_PATH;
    public static final PathUtil INSTANCE;

    @NotNull
    public final Pattern getKOTLIN_STDLIB_JS_JAR_PATTERN() {
        return KOTLIN_STDLIB_JS_JAR_PATTERN;
    }

    @NotNull
    public final Pattern getKOTLIN_STDLIB_COMMON_JAR_PATTERN() {
        return KOTLIN_STDLIB_COMMON_JAR_PATTERN;
    }

    @NotNull
    public final Pattern getKOTLIN_JS_LIBRARY_JAR_PATTERN() {
        return KOTLIN_JS_LIBRARY_JAR_PATTERN;
    }

    @JvmStatic
    public static /* synthetic */ void kotlinPathsForIdeaPlugin$annotations() {
    }

    @NotNull
    public static final KotlinPaths getKotlinPathsForIdeaPlugin() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        return application.isUnitTestMode() ? PathUtil.getKotlinPathsForDistDirectory() : (KotlinPaths)new KotlinPathsFromHomeDir(INSTANCE.getCompilerPathForIdeaPlugin());
    }

    @JvmStatic
    public static /* synthetic */ void kotlinPathsForCompiler$annotations() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final KotlinPaths getKotlinPathsForCompiler() {
        KotlinPaths kotlinPaths;
        if (INSTANCE.getPathUtilJar().isFile()) {
            String string = INSTANCE.getPathUtilJar().getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pathUtilJar.name");
            if (StringsKt.startsWith$default((String)string, (String)KOTLIN_COMPILER, (boolean)false, (int)2, null)) {
                kotlinPaths = new KotlinPathsFromHomeDir(INSTANCE.getCompilerPathForCompilerJar());
                return kotlinPaths;
            }
        }
        kotlinPaths = PathUtil.getKotlinPathsForDistDirectory();
        return kotlinPaths;
    }

    @JvmStatic
    public static /* synthetic */ void kotlinPathsForDistDirectory$annotations() {
    }

    @NotNull
    public static final KotlinPaths getKotlinPathsForDistDirectory() {
        return new KotlinPathsFromHomeDir(new File("dist", HOME_FOLDER_NAME));
    }

    private final File getCompilerPathForCompilerJar() {
        File jar = this.getPathUtilJar();
        if (!jar.exists()) {
            return NO_PATH;
        }
        if (Intrinsics.areEqual((Object)jar.getName(), (Object)KOTLIN_COMPILER_JAR)) {
            File lib;
            File file = lib = jar.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"lib");
            File file2 = file.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"lib.parentFile");
            return file2;
        }
        return NO_PATH;
    }

    private final File getCompilerPathForIdeaPlugin() {
        File jar = this.getPathUtilJar();
        if (!jar.exists()) {
            return NO_PATH;
        }
        if (Intrinsics.areEqual((Object)jar.getName(), (Object)"kotlin-plugin.jar")) {
            File lib;
            File file = lib = jar.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"lib");
            File pluginHome = file.getParentFile();
            return new File(pluginHome, HOME_FOLDER_NAME);
        }
        return NO_PATH;
    }

    @NotNull
    public final File getPathUtilJar() {
        return PathUtil.getResourcePathForClass(PathUtil.class);
    }

    @JvmStatic
    @NotNull
    public static final File getResourcePathForClass(@NotNull Class<?> aClass2) {
        Intrinsics.checkParameterIsNotNull(aClass2, (String)"aClass");
        StringBuilder stringBuilder = new StringBuilder().append("/");
        String string = aClass2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"aClass.name");
        String path2 = stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(".class").toString();
        String string2 = PathManager.getResourceRoot(aClass2, path2);
        if (string2 == null) {
            throw (Throwable)new IllegalStateException("Resource not found: " + path2);
        }
        String resourceRoot = string2;
        File file = new File(resourceRoot).getAbsoluteFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"File(resourceRoot).absoluteFile");
        return file;
    }

    @JvmStatic
    @NotNull
    public static final List<File> getJdkClassesRootsFromCurrentJre() {
        String string = System.getProperty("java.home");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"java.home\")");
        return PathUtil.getJdkClassesRootsFromJre(string);
    }

    @JvmStatic
    @NotNull
    public static final List<File> getJdkClassesRootsFromJre(@NotNull String javaHome) {
        Intrinsics.checkParameterIsNotNull((Object)javaHome, (String)"javaHome");
        List<File> list2 = JavaSdkUtil.getJdkClassesRoots(new File(javaHome), true);
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"JavaSdkUtil.getJdkClasse\u2026ots(File(javaHome), true)");
        return list2;
    }

    @JvmStatic
    @NotNull
    public static final List<File> getJdkClassesRoots(@NotNull File jdkHome) {
        Intrinsics.checkParameterIsNotNull((Object)jdkHome, (String)"jdkHome");
        List<File> list2 = JavaSdkUtil.getJdkClassesRoots(jdkHome, false);
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"JavaSdkUtil.getJdkClassesRoots(jdkHome, false)");
        return list2;
    }

    private PathUtil() {
    }

    static {
        PathUtil pathUtil;
        INSTANCE = pathUtil = new PathUtil();
        Pattern pattern = Pattern.compile("kotlin-(stdlib|runtime)(-\\d[\\d.]+(-.+)?)?\\.jar");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"kotlin-\u2026\\d[\\\\d.]+(-.+)?)?\\\\.jar\")");
        KOTLIN_RUNTIME_JAR_PATTERN = pattern;
        Pattern pattern2 = Pattern.compile("kotlin-stdlib-js.*\\.jar");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern2, (String)"Pattern.compile(\"kotlin-stdlib-js.*\\\\.jar\")");
        KOTLIN_STDLIB_JS_JAR_PATTERN = pattern2;
        Pattern pattern3 = Pattern.compile("kotlin-stdlib-common.*\\.jar");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern3, (String)"Pattern.compile(\"kotlin-stdlib-common.*\\\\.jar\")");
        KOTLIN_STDLIB_COMMON_JAR_PATTERN = pattern3;
        Pattern pattern4 = Pattern.compile("kotlin-js-library.*\\.jar");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern4, (String)"Pattern.compile(\"kotlin-js-library.*\\\\.jar\")");
        KOTLIN_JS_LIBRARY_JAR_PATTERN = pattern4;
        NO_PATH = new File("<no_path>");
    }
}

