/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.AbstractVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.ExactVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.SubVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionRangeSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;

public class DefaultVersionSelectorScheme
implements VersionSelectorScheme {
    private final VersionComparator versionComparator;

    public DefaultVersionSelectorScheme(VersionComparator versionComparator) {
        this.versionComparator = versionComparator;
    }

    @Override
    public VersionSelector parseSelector(String selectorString) {
        if (VersionRangeSelector.ALL_RANGE.matcher(selectorString).matches()) {
            return new VersionRangeSelector(selectorString, this.versionComparator.asVersionComparator());
        }
        if (selectorString.endsWith("+")) {
            return new SubVersionSelector(selectorString);
        }
        if (selectorString.startsWith("latest.")) {
            return new LatestVersionSelector(selectorString);
        }
        return new ExactVersionSelector(selectorString);
    }

    @Override
    public String renderSelector(VersionSelector selector) {
        return ((AbstractVersionSelector)selector).getSelector();
    }

    @Override
    public VersionSelector complementForRejection(VersionSelector selector) {
        VersionRangeSelector vrs;
        if (selector instanceof ExactVersionSelector) {
            return new VersionRangeSelector("]" + ((ExactVersionSelector)selector).getSelector() + ",)", this.versionComparator.asVersionComparator());
        }
        if (selector instanceof VersionRangeSelector && (vrs = (VersionRangeSelector)selector).getUpperBound() != null) {
            String lowerBoundInclusion = vrs.isUpperInclusive() ? "]" : "[";
            return new VersionRangeSelector(lowerBoundInclusion + vrs.getUpperBound() + ",)", this.versionComparator.asVersionComparator());
        }
        throw new IllegalArgumentException("Version '" + this.renderSelector(selector) + "' cannot be converted to a strict version constraint.");
    }
}

