/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyMetadata;
import org.gradle.api.artifacts.DirectDependencyMetadata;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.internal.Cast;

public abstract class AbstractDependencyImpl<T extends DirectDependencyMetadata>
implements DependencyMetadata<T> {
    private final String group;
    private final String name;
    private MutableVersionConstraint versionConstraint;

    public AbstractDependencyImpl(String group, String name, String version) {
        this.group = group;
        this.name = name;
        this.versionConstraint = new DefaultMutableVersionConstraint(version);
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public T version(Action<? super MutableVersionConstraint> configureAction) {
        configureAction.execute((Object)this.versionConstraint);
        return (T)((DirectDependencyMetadata)Cast.uncheckedCast((Object)this));
    }

    public String toString() {
        return this.getGroup() + ":" + this.getName() + ":" + this.getVersionConstraint();
    }
}

