/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetaData;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.api.internal.artifacts.transform.TransformedFileCache;
import org.gradle.api.internal.changedetection.state.FileSystemSnapshotter;
import org.gradle.api.internal.changedetection.state.InMemoryCacheDecoratorFactory;
import org.gradle.api.internal.changedetection.state.Snapshot;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.resource.local.DefaultPathKeyFileStore;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.FileStoreAddActionException;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.util.BiFunction;

public class DefaultTransformedFileCache
implements TransformedFileCache,
Stoppable,
RootBuildLifecycleListener {
    private final PersistentCache cache;
    private final PersistentIndexedCache<HashCode, List<File>> indexedCache;
    private final FileStore<String> fileStore;
    private final ProducerGuard<CacheKey> producing = ProducerGuard.adaptive();
    private final Map<CacheKey, List<File>> resultHashToResult = new ConcurrentHashMap<CacheKey, List<File>>();
    private final FileSystemSnapshotter fileSystemSnapshotter;

    public DefaultTransformedFileCache(ArtifactCacheMetaData artifactCacheMetaData, CacheRepository cacheRepository, InMemoryCacheDecoratorFactory cacheDecoratorFactory, FileSystemSnapshotter fileSystemSnapshotter) {
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        File transformsStoreDirectory = artifactCacheMetaData.getTransformsStoreDirectory();
        File filesOutputDirectory = new File(transformsStoreDirectory, CacheLayout.TRANSFORMS_STORE.getKey());
        this.fileStore = new DefaultPathKeyFileStore(filesOutputDirectory);
        this.cache = cacheRepository.cache(transformsStoreDirectory).withCrossVersionCache(CacheBuilder.LockTarget.DefaultTarget).withDisplayName("Artifact transforms cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).open();
        String cacheName = CacheLayout.TRANSFORMS_META_DATA.getKey() + "/results";
        PersistentIndexedCacheParameters cacheParameters = new PersistentIndexedCacheParameters(cacheName, (Serializer)new HashCodeSerializer(), (Serializer)new ListSerializer(BaseSerializerFactory.FILE_SERIALIZER)).cacheDecorator(cacheDecoratorFactory.decorator(1000, true));
        this.indexedCache = this.cache.createCache(cacheParameters);
    }

    public void stop() {
        this.cache.close();
    }

    public void afterStart() {
    }

    public void beforeComplete() {
        this.resultHashToResult.clear();
    }

    @Override
    public boolean contains(File absoluteFile, HashCode inputsHash) {
        return this.resultHashToResult.containsKey(this.getCacheKey(absoluteFile, inputsHash));
    }

    @Override
    public List<File> getResult(File inputFile, HashCode inputsHash, BiFunction<List<File>, File, File> transformer) {
        CacheKey resultHash = this.getCacheKey(inputFile, inputsHash);
        List<File> files = this.resultHashToResult.get(resultHash);
        if (files != null) {
            return files;
        }
        return this.loadIntoCache(inputFile, resultHash, transformer);
    }

    private List<File> loadIntoCache(final File inputFile, final CacheKey cacheKey, final BiFunction<List<File>, File, File> transformer) {
        return (List)this.producing.guardByKey((Object)cacheKey, (Factory)new Factory<List<File>>(){

            public List<File> create() {
                List files = (List)DefaultTransformedFileCache.this.resultHashToResult.get(cacheKey);
                if (files != null) {
                    return files;
                }
                files = (List)DefaultTransformedFileCache.this.cache.withFileLock((Factory)new Factory<List<File>>(){

                    public List<File> create() {
                        HashCode persistentCacheKey = cacheKey.getPersistentCacheKey();
                        List files = (List)DefaultTransformedFileCache.this.indexedCache.get((Object)persistentCacheKey);
                        if (files != null) {
                            boolean allExist = true;
                            for (File file : files) {
                                if (file.exists()) continue;
                                allExist = false;
                                break;
                            }
                            if (allExist) {
                                return files;
                            }
                        }
                        String key = inputFile.getName() + "/" + persistentCacheKey;
                        TransformAction action = new TransformAction((BiFunction<List<File>, File, File>)transformer, inputFile);
                        try {
                            DefaultTransformedFileCache.this.fileStore.add((Object)key, (Action)action);
                        }
                        catch (FileStoreAddActionException e) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
                        }
                        DefaultTransformedFileCache.this.indexedCache.put((Object)persistentCacheKey, (Object)action.result);
                        return action.result;
                    }
                });
                DefaultTransformedFileCache.this.resultHashToResult.put(cacheKey, files);
                return files;
            }
        });
    }

    private CacheKey getCacheKey(File inputFile, HashCode inputsHash) {
        Snapshot inputFileSnapshot = this.fileSystemSnapshotter.snapshotAll(inputFile);
        return new CacheKey(inputFileSnapshot, inputsHash);
    }

    private static class TransformAction
    implements Action<File> {
        private final BiFunction<List<File>, File, File> transformer;
        private final File inputFile;
        private ImmutableList<File> result;

        TransformAction(BiFunction<List<File>, File, File> transformer, File inputFile) {
            this.transformer = transformer;
            this.inputFile = inputFile;
        }

        public void execute(File outputDir) {
            outputDir.mkdirs();
            this.result = ImmutableList.copyOf((Collection)((Collection)this.transformer.apply((Object)this.inputFile, (Object)outputDir)));
        }
    }

    private static class CacheKey {
        private final Snapshot fileSnapshot;
        private final HashCode inputHash;

        public CacheKey(Snapshot fileSnapshot, HashCode inputHash) {
            this.fileSnapshot = fileSnapshot;
            this.inputHash = inputHash;
        }

        public HashCode getPersistentCacheKey() {
            DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
            hasher.putHash(this.inputHash);
            this.fileSnapshot.appendToHasher((BuildCacheHasher)hasher);
            return hasher.hash();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.fileSnapshot.equals(cacheKey.fileSnapshot)) {
                return false;
            }
            return this.inputHash.equals((Object)cacheKey.inputHash);
        }

        public int hashCode() {
            int result = this.fileSnapshot.hashCode();
            result = 31 * result + this.inputHash.hashCode();
            return result;
        }
    }
}

