/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantResolveMetadata;

public class DefaultConfigurationMetadata
implements ConfigurationMetadata,
VariantResolveMetadata {
    private final ModuleComponentIdentifier componentId;
    private final String name;
    private final ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts;
    private final boolean transitive;
    private final boolean visible;
    private final ImmutableList<String> hierarchy;
    private final VariantMetadataRules componentMetadataRules;
    private final ImmutableList<ExcludeMetadata> excludes;
    private final ImmutableAttributes attributes;
    private ImmutableList<ModuleDependencyMetadata> configDependencies;
    private List<ModuleDependencyMetadata> calculatedDependencies;
    private ImmutableAttributes computedAttributes;

    protected DefaultConfigurationMetadata(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableList<String> hierarchy, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts, VariantMetadataRules componentMetadataRules, ImmutableList<ExcludeMetadata> excludes) {
        this(componentId, name, transitive, visible, hierarchy, artifacts, componentMetadataRules, excludes, ImmutableAttributes.EMPTY, null);
    }

    private DefaultConfigurationMetadata(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableList<String> hierarchy, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts, VariantMetadataRules componentMetadataRules, ImmutableList<ExcludeMetadata> excludes, ImmutableAttributes attributes, ImmutableList<ModuleDependencyMetadata> configDependencies) {
        this.componentId = componentId;
        this.name = name;
        this.transitive = transitive;
        this.visible = visible;
        this.artifacts = artifacts;
        this.hierarchy = hierarchy;
        this.componentMetadataRules = componentMetadataRules;
        this.excludes = excludes;
        this.attributes = attributes;
        this.configDependencies = configDependencies;
    }

    @Override
    public DisplayName asDescribable() {
        return Describables.of((Object)this.componentId, (Object)"configuration", (Object)this.name);
    }

    public String toString() {
        return this.asDescribable().getDisplayName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<String> getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        if (this.computedAttributes == null) {
            this.computedAttributes = this.componentMetadataRules.applyVariantAttributeRules(this, (AttributeContainerInternal)this.attributes);
        }
        return this.computedAttributes;
    }

    @Override
    public boolean isCanBeConsumed() {
        return true;
    }

    @Override
    public boolean isCanBeResolved() {
        return false;
    }

    @Override
    public List<? extends DependencyMetadata> getDependencies() {
        if (this.calculatedDependencies == null) {
            this.calculatedDependencies = this.componentMetadataRules.applyDependencyMetadataRules(this, this.configDependencies);
        }
        return this.calculatedDependencies;
    }

    protected void setDependencies(List<ModuleDependencyMetadata> dependencies) {
        assert (this.configDependencies == null);
        this.configDependencies = ImmutableList.copyOf(dependencies);
    }

    public List<? extends ModuleComponentArtifactMetadata> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public Set<? extends VariantResolveMetadata> getVariants() {
        return ImmutableSet.of((Object)new DefaultVariantMetadata(this.asDescribable(), (AttributeContainerInternal)this.getAttributes(), this.getArtifacts()));
    }

    @Override
    public ImmutableList<ExcludeMetadata> getExcludes() {
        return this.excludes;
    }

    @Override
    public ModuleComponentArtifactMetadata artifact(IvyArtifactName artifact) {
        return new DefaultModuleComponentArtifactMetadata(this.componentId, artifact);
    }

    protected DefaultConfigurationMetadata withAttributes(ImmutableAttributes attributes) {
        return new DefaultConfigurationMetadata(this.componentId, this.name, this.transitive, this.visible, this.hierarchy, this.artifacts, this.componentMetadataRules, this.excludes, attributes, this.configDependencies);
    }
}

