/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.management.internal.autoapply;

import java.util.Collections;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.plugin.management.internal.DefaultPluginRequest;
import org.gradle.plugin.management.internal.DefaultPluginRequests;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedBuildScanPlugin;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginRegistry;

public class DefaultAutoAppliedPluginRegistry
implements AutoAppliedPluginRegistry {
    private final StartParameter startParameter;

    public DefaultAutoAppliedPluginRegistry(StartParameter startParameter) {
        this.startParameter = startParameter;
    }

    public PluginRequests getAutoAppliedPlugins(Project target) {
        if (this.shouldApplyScanPlugin(target)) {
            return new DefaultPluginRequests(Collections.singletonList(this.createScanPluginRequest()));
        }
        return DefaultPluginRequests.EMPTY;
    }

    private boolean shouldApplyScanPlugin(Project target) {
        return this.startParameter.isBuildScan() && target.getParent() == null && target.getGradle().getParent() == null;
    }

    private DefaultPluginRequest createScanPluginRequest() {
        ModuleVersionSelector artifact = DefaultModuleVersionSelector.newSelector((String)"com.gradle", (String)"build-scan-plugin", (String)"1.11");
        return new DefaultPluginRequest(AutoAppliedBuildScanPlugin.ID, "1.11", true, null, DefaultAutoAppliedPluginRegistry.getScriptDisplayName(), artifact);
    }

    private static String getScriptDisplayName() {
        return String.format("auto-applied by using --%s", "scan");
    }
}

