/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileSystemMirror;
import org.gradle.api.internal.changedetection.state.FileTreeSnapshot;
import org.gradle.api.internal.changedetection.state.Snapshot;
import org.gradle.api.internal.tasks.execution.TaskOutputsGenerationListener;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.classpath.CachedJarFileStore;
import org.gradle.internal.file.DefaultFileHierarchySet;
import org.gradle.internal.file.FileHierarchySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileSystemMirror
implements FileSystemMirror,
TaskOutputsGenerationListener,
RootBuildLifecycleListener {
    private final Map<String, FileSnapshot> files = new ConcurrentHashMap<String, FileSnapshot>();
    private final Map<String, FileSnapshot> cacheFiles = new ConcurrentHashMap<String, FileSnapshot>();
    private final Map<String, FileTreeSnapshot> trees = new ConcurrentHashMap<String, FileTreeSnapshot>();
    private final Map<String, FileTreeSnapshot> cacheTrees = new ConcurrentHashMap<String, FileTreeSnapshot>();
    private final Map<String, Snapshot> snapshots = new ConcurrentHashMap<String, Snapshot>();
    private final Map<String, Snapshot> cacheSnapshots = new ConcurrentHashMap<String, Snapshot>();
    private final FileHierarchySet cachedDirectories;

    public DefaultFileSystemMirror(List<CachedJarFileStore> fileStores) {
        FileHierarchySet cachedDirectories = DefaultFileHierarchySet.of();
        for (CachedJarFileStore fileStore : fileStores) {
            for (File file : fileStore.getFileStoreRoots()) {
                cachedDirectories = cachedDirectories.plus(file);
            }
        }
        this.cachedDirectories = cachedDirectories;
    }

    @Override
    @Nullable
    public FileSnapshot getFile(String path) {
        if (this.cachedDirectories.contains(path)) {
            return this.cacheFiles.get(path);
        }
        return this.files.get(path);
    }

    @Override
    public void putFile(FileSnapshot file) {
        if (this.cachedDirectories.contains(file.getPath())) {
            this.cacheFiles.put(file.getPath(), file);
        } else {
            this.files.put(file.getPath(), file);
        }
    }

    @Override
    @Nullable
    public Snapshot getContent(String path) {
        if (this.cachedDirectories.contains(path)) {
            return this.cacheSnapshots.get(path);
        }
        return this.snapshots.get(path);
    }

    @Override
    public void putContent(String path, Snapshot snapshot) {
        if (this.cachedDirectories.contains(path)) {
            this.cacheSnapshots.put(path, snapshot);
        } else {
            this.snapshots.put(path, snapshot);
        }
    }

    @Override
    @Nullable
    public FileTreeSnapshot getDirectoryTree(String path) {
        if (this.cachedDirectories.contains(path)) {
            return this.cacheTrees.get(path);
        }
        return this.trees.get(path);
    }

    @Override
    public void putDirectory(FileTreeSnapshot directory) {
        if (this.cachedDirectories.contains(directory.getPath())) {
            this.cacheTrees.put(directory.getPath(), directory);
        } else {
            this.trees.put(directory.getPath(), directory);
        }
    }

    @Override
    public void beforeTaskOutputsGenerated() {
        this.files.clear();
        this.trees.clear();
        this.snapshots.clear();
    }

    @Override
    public void afterStart() {
    }

    @Override
    public void beforeComplete() {
        this.files.clear();
        this.cacheFiles.clear();
        this.trees.clear();
        this.cacheTrees.clear();
        this.snapshots.clear();
        this.cacheSnapshots.clear();
    }
}

