/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.assembler.tasks;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.assembler.internal.DefaultAssembleSpec;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.SimpleStaleClassCleaner;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.compilespec.AssembleSpec;

@Incubating
public class Assemble
extends DefaultTask {
    private ConfigurableFileCollection source = this.getProject().files(new Object[0]);
    private ConfigurableFileCollection includes = this.getProject().files(new Object[0]);
    private NativeToolChainInternal toolChain;
    private NativePlatformInternal targetPlatform;
    private File objectFileDir;
    private List<String> assemblerArgs;

    @Inject
    public Assemble() {
        this.getInputs().property("outputType", (Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return NativeToolChainInternal.Identifier.identify((NativeToolChainInternal)Assemble.this.toolChain, (NativePlatformInternal)Assemble.this.targetPlatform);
            }
        });
    }

    @Inject
    public BuildOperationLoggerFactory getOperationLoggerFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void assemble() {
        BuildOperationLogger operationLogger = this.getOperationLoggerFactory().newOperationLogger(this.getName(), this.getTemporaryDir());
        SimpleStaleClassCleaner cleaner = new SimpleStaleClassCleaner(this.getOutputs());
        cleaner.setDestinationDir(this.getObjectFileDir());
        cleaner.execute();
        DefaultAssembleSpec spec = new DefaultAssembleSpec();
        spec.setTempDir(this.getTemporaryDir());
        spec.setObjectFileDir(this.getObjectFileDir());
        spec.source((Iterable<File>)this.getSource());
        spec.include((Iterable<File>)this.getIncludes());
        spec.args(this.getAssemblerArgs());
        spec.setOperationLogger(operationLogger);
        Compiler compiler = this.toolChain.select(this.targetPlatform).newCompiler(AssembleSpec.class);
        WorkResult result = BuildOperationLoggingCompilerDecorator.wrap((Compiler)compiler).execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    @InputFiles
    @SkipWhenEmpty
    public ConfigurableFileCollection getSource() {
        return this.source;
    }

    public void source(Object sourceFiles) {
        this.source.from(new Object[]{sourceFiles});
    }

    @Input
    public List<String> getAssemblerArgs() {
        return this.assemblerArgs;
    }

    public void setAssemblerArgs(List<String> assemblerArgs) {
        this.assemblerArgs = assemblerArgs;
    }

    @Internal
    public NativeToolChain getToolChain() {
        return this.toolChain;
    }

    public void setToolChain(NativeToolChain toolChain) {
        this.toolChain = (NativeToolChainInternal)toolChain;
    }

    @Nested
    public NativePlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public void setTargetPlatform(NativePlatform targetPlatform) {
        this.targetPlatform = (NativePlatformInternal)targetPlatform;
    }

    @OutputDirectory
    public File getObjectFileDir() {
        return this.objectFileDir;
    }

    public void setObjectFileDir(File objectFileDir) {
        this.objectFileDir = objectFileDir;
    }

    @InputFiles
    public ConfigurableFileCollection getIncludes() {
        return this.includes;
    }

    public void includes(Object includeRoots) {
        this.includes.from(new Object[]{includeRoots});
    }
}

