/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.Provider;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.CppSharedLibrary;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.tasks.CppCompile;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.plugins.NativeBasePlugin;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.SystemIncludesAwarePlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.plugins.StandardToolChainsPlugin;

@Incubating
@NonNullApi
public class CppBasePlugin
implements Plugin<ProjectInternal> {
    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(NativeBasePlugin.class);
        project.getPluginManager().apply(StandardToolChainsPlugin.class);
        final TaskContainerInternal tasks = project.getTasks();
        final DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        project.getGradle().getExperimentalFeatures().enable();
        project.getComponents().withType(DefaultCppBinary.class, (Action)new Action<DefaultCppBinary>(){

            public void execute(final DefaultCppBinary binary) {
                Names names = binary.getNames();
                String language = "cpp";
                CppPlatform currentPlatform = binary.getTargetPlatform();
                NativeToolChainInternal toolChain = binary.getToolChain();
                Callable<List<File>> systemIncludes = new Callable<List<File>>(){

                    @Override
                    public List<File> call() {
                        PlatformToolProvider platformToolProvider = binary.getPlatformToolProvider();
                        if (platformToolProvider instanceof SystemIncludesAwarePlatformToolProvider) {
                            return ((SystemIncludesAwarePlatformToolProvider)platformToolProvider).getSystemIncludes(ToolType.CPP_COMPILER);
                        }
                        return ImmutableList.of();
                    }
                };
                CppCompile compile = (CppCompile)tasks.create(names.getCompileTaskName(language), CppCompile.class);
                compile.includes(binary.getCompileIncludePath());
                compile.includes(systemIncludes);
                compile.source(binary.getCppSource());
                if (binary.isDebuggable()) {
                    compile.setDebuggable(true);
                }
                if (binary.isOptimized()) {
                    compile.setOptimized(true);
                }
                compile.setTargetPlatform(currentPlatform);
                compile.setToolChain((NativeToolChain)toolChain);
                compile.getObjectFileDir().set(buildDirectory.dir("obj/" + names.getDirName()));
                binary.getObjectsDir().set((Provider)compile.getObjectFileDir());
                binary.getCompileTask().set((Object)compile);
            }
        });
        project.getComponents().withType(CppSharedLibrary.class, (Action)new Action<CppSharedLibrary>(){

            public void execute(CppSharedLibrary library) {
                ((CppCompile)((Object)library.getCompileTask().get())).setPositionIndependentCode(true);
            }
        });
    }
}

