/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.toolchains;

import javax.inject.Inject;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppPlatform;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.internal.DefaultSwiftPlatform;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.Platform;

public class DefaultToolChainSelector
implements ToolChainSelector {
    private final ModelRegistry modelRegistry;

    @Inject
    public DefaultToolChainSelector(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
    }

    @Override
    public <T extends NativePlatform> ToolChainSelector.Result<T> select(Class<T> platformType) {
        DefaultNativePlatform platformRequest = new DefaultNativePlatform("current");
        NativeToolChainInternal toolChain = (NativeToolChainInternal)((NativeToolChainRegistryInternal)this.modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class)).getForPlatform((Platform)platformRequest);
        PlatformToolProvider toolProvider = toolChain.select((NativePlatformInternal)platformRequest);
        NativePlatform targetPlatform = null;
        if (CppPlatform.class.isAssignableFrom(platformType)) {
            targetPlatform = (NativePlatform)platformType.cast(new DefaultCppPlatform("current"));
        } else if (SwiftPlatform.class.isAssignableFrom(platformType)) {
            targetPlatform = (NativePlatform)platformType.cast(new DefaultSwiftPlatform("current"));
        }
        return new DefaultResult(this, toolChain, toolProvider, targetPlatform);
    }

    static class DefaultResult<T extends NativePlatform>
    implements ToolChainSelector.Result<T> {
        private final NativeToolChainInternal toolChain;
        private final PlatformToolProvider platformToolProvider;
        private final T targetPlatform;
        final /* synthetic */ DefaultToolChainSelector this$0;

        DefaultResult(NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider, T targetPlatform) {
            this.this$0 = var1_1;
            this.toolChain = toolChain;
            this.platformToolProvider = platformToolProvider;
            this.targetPlatform = targetPlatform;
        }

        @Override
        public NativeToolChainInternal getToolChain() {
            return this.toolChain;
        }

        @Override
        public T getTargetPlatform() {
            return this.targetPlatform;
        }

        @Override
        public PlatformToolProvider getPlatformToolProvider() {
            return this.platformToolProvider;
        }
    }
}

