/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.plugins;

import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.ComponentWithBinaries;
import org.gradle.language.ComponentWithOutputs;
import org.gradle.language.ProductionComponent;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.nativeplatform.internal.ComponentWithNames;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithExecutable;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithLinkUsage;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithRuntimeUsage;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithSharedLibrary;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithStaticLibrary;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.nativeplatform.internal.PublicationAwareComponent;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.tasks.CreateStaticLibrary;
import org.gradle.nativeplatform.tasks.ExtractSymbols;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.tasks.StripSymbols;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.ToolChain;
import org.gradle.util.GUtil;

@Incubating
public class NativeBasePlugin
implements Plugin<ProjectInternal> {
    public void apply(final ProjectInternal project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        TaskContainerInternal tasks = project.getTasks();
        ProviderFactory providers = project.getProviders();
        DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        final SoftwareComponentContainer components = project.getComponents();
        components.withType(ComponentWithBinaries.class, (Action)new Action<ComponentWithBinaries>((TaskContainer)tasks){
            final /* synthetic */ TaskContainer val$tasks;
            {
                this.val$tasks = taskContainer;
            }

            public void execute(final ComponentWithBinaries component) {
                component.getBinaries().whenElementKnown((Action<? extends SoftwareComponent>)new Action<SoftwareComponent>(){

                    public void execute(SoftwareComponent binary) {
                        components.add((Object)binary);
                    }
                });
                if (component instanceof ProductionComponent) {
                    component.getBinaries().whenElementFinalized(ComponentWithOutputs.class, new Action<ComponentWithOutputs>(){

                        public void execute(ComponentWithOutputs binary) {
                            FileCollection outputs = binary.getOutputs();
                            Names names = ((ComponentWithNames)((Object)binary)).getNames();
                            Task lifecycleTask = val$tasks.create(names.getTaskName("assemble"));
                            lifecycleTask.dependsOn(new Object[]{outputs});
                            if (binary == ((ProductionComponent)((Object)component)).getDevelopmentBinary().get()) {
                                val$tasks.getByName("assemble").dependsOn(new Object[]{outputs});
                            }
                        }
                    });
                }
            }
        });
        components.withType(ConfigurableComponentWithExecutable.class, (Action)new Action<ConfigurableComponentWithExecutable>((TaskContainer)tasks, buildDirectory, providers){
            final /* synthetic */ TaskContainer val$tasks;
            final /* synthetic */ DirectoryProperty val$buildDirectory;
            final /* synthetic */ ProviderFactory val$providers;
            {
                this.val$tasks = taskContainer;
                this.val$buildDirectory = directoryProperty;
                this.val$providers = providerFactory;
            }

            public void execute(final ConfigurableComponentWithExecutable executable) {
                final Names names = executable.getNames();
                NativeToolChain toolChain = executable.getToolChain();
                NativePlatform targetPlatform = executable.getTargetPlatform();
                LinkExecutable link = (LinkExecutable)this.val$tasks.create(names.getTaskName("link"), LinkExecutable.class);
                link.source((Object)executable.getObjects());
                link.lib((Object)executable.getLinkLibraries());
                final PlatformToolProvider toolProvider = executable.getPlatformToolProvider();
                link.setOutputFile(this.val$buildDirectory.file(this.val$providers.provider((Callable)new Callable<String>(){

                    @Override
                    public String call() {
                        return toolProvider.getExecutableName("exe/" + names.getDirName() + (String)executable.getBaseName().get());
                    }
                })));
                link.setTargetPlatform(targetPlatform);
                link.setToolChain(toolChain);
                link.setDebuggable(executable.isDebuggable());
                executable.getLinkTask().set((Object)link);
                executable.getDebuggerExecutableFile().set((Provider)link.getBinaryFile());
                if (executable.isDebuggable() && executable.isOptimized() && toolProvider.requiresDebugBinaryStripping()) {
                    Provider symbolLocation = this.val$buildDirectory.file(this.val$providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getExecutableSymbolFileName("exe/" + names.getDirName() + "stripped/" + (String)executable.getBaseName().get());
                        }
                    }));
                    Provider strippedLocation = this.val$buildDirectory.file(this.val$providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getExecutableName("exe/" + names.getDirName() + "stripped/" + (String)executable.getBaseName().get());
                        }
                    }));
                    StripSymbols stripSymbols = NativeBasePlugin.this.stripSymbols((AbstractLinkTask)link, names, this.val$tasks, toolChain, targetPlatform, (Provider<RegularFile>)strippedLocation);
                    executable.getExecutableFile().set((Provider)stripSymbols.getOutputFile());
                    ExtractSymbols extractSymbols = NativeBasePlugin.this.extractSymbols((AbstractLinkTask)link, names, this.val$tasks, toolChain, targetPlatform, (Provider<RegularFile>)symbolLocation);
                    executable.getOutputs().from(new Object[]{extractSymbols.getSymbolFile()});
                } else {
                    executable.getExecutableFile().set((Provider)link.getBinaryFile());
                }
                InstallExecutable install = (InstallExecutable)this.val$tasks.create(names.getTaskName("install"), InstallExecutable.class);
                install.setPlatform(link.getTargetPlatform());
                install.setToolChain((ToolChain)link.getToolChain());
                install.getInstallDirectory().set(this.val$buildDirectory.dir("install/" + names.getDirName()));
                install.getSourceFile().set(executable.getExecutableFile());
                install.lib((Object)executable.getRuntimeLibraries());
                executable.getInstallTask().set((Object)install);
                executable.getInstallDirectory().set((Provider)install.getInstallDirectory());
                executable.getOutputs().from(new Object[]{executable.getInstallDirectory()});
            }
        });
        components.withType(ConfigurableComponentWithSharedLibrary.class, (Action)new Action<ConfigurableComponentWithSharedLibrary>((TaskContainer)tasks, buildDirectory, providers){
            final /* synthetic */ TaskContainer val$tasks;
            final /* synthetic */ DirectoryProperty val$buildDirectory;
            final /* synthetic */ ProviderFactory val$providers;
            {
                this.val$tasks = taskContainer;
                this.val$buildDirectory = directoryProperty;
                this.val$providers = providerFactory;
            }

            public void execute(final ConfigurableComponentWithSharedLibrary library) {
                final Names names = library.getNames();
                NativePlatform targetPlatform = library.getTargetPlatform();
                NativeToolChain toolChain = library.getToolChain();
                LinkSharedLibrary link = (LinkSharedLibrary)this.val$tasks.create(names.getTaskName("link"), LinkSharedLibrary.class);
                link.source((Object)library.getObjects());
                link.lib((Object)library.getLinkLibraries());
                final PlatformToolProvider toolProvider = library.getPlatformToolProvider();
                Provider runtimeFile = this.val$buildDirectory.file(this.val$providers.provider((Callable)new Callable<String>(){

                    @Override
                    public String call() {
                        return toolProvider.getSharedLibraryName("lib/" + names.getDirName() + (String)library.getBaseName().get());
                    }
                }));
                link.setOutputFile(runtimeFile);
                link.setTargetPlatform(targetPlatform);
                link.setToolChain(toolChain);
                link.setDebuggable(library.isDebuggable());
                RegularFileProperty linkFile = link.getBinaryFile();
                runtimeFile = link.getBinaryFile();
                if (toolProvider.producesImportLibrary()) {
                    Provider importLibrary = this.val$buildDirectory.file(this.val$providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getImportLibraryName("lib/" + names.getDirName() + (String)library.getBaseName().get());
                        }
                    }));
                    link.getImportLibrary().set(importLibrary);
                    linkFile = link.getImportLibrary();
                }
                if (library.isDebuggable() && library.isOptimized() && toolProvider.requiresDebugBinaryStripping()) {
                    Provider symbolLocation = this.val$buildDirectory.file(this.val$providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getLibrarySymbolFileName("lib/" + names.getDirName() + "stripped/" + (String)library.getBaseName().get());
                        }
                    }));
                    Provider strippedLocation = this.val$buildDirectory.file(this.val$providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getSharedLibraryName("lib/" + names.getDirName() + "stripped/" + (String)library.getBaseName().get());
                        }
                    }));
                    StripSymbols stripSymbols = NativeBasePlugin.this.stripSymbols((AbstractLinkTask)link, names, this.val$tasks, toolChain, targetPlatform, (Provider<RegularFile>)strippedLocation);
                    runtimeFile = stripSymbols.getOutputFile();
                    linkFile = stripSymbols.getOutputFile();
                    ExtractSymbols extractSymbols = NativeBasePlugin.this.extractSymbols((AbstractLinkTask)link, names, this.val$tasks, toolChain, targetPlatform, (Provider<RegularFile>)symbolLocation);
                    library.getOutputs().from(new Object[]{extractSymbols.getSymbolFile()});
                }
                library.getLinkTask().set((Object)link);
                library.getLinkFile().set((Provider)linkFile);
                library.getRuntimeFile().set(runtimeFile);
                library.getOutputs().from(new Object[]{library.getLinkFile()});
                library.getOutputs().from(new Object[]{library.getRuntimeFile()});
            }
        });
        components.withType(ConfigurableComponentWithStaticLibrary.class, (Action)new Action<ConfigurableComponentWithStaticLibrary>((TaskContainer)tasks, buildDirectory, providers){
            final /* synthetic */ TaskContainer val$tasks;
            final /* synthetic */ DirectoryProperty val$buildDirectory;
            final /* synthetic */ ProviderFactory val$providers;
            {
                this.val$tasks = taskContainer;
                this.val$buildDirectory = directoryProperty;
                this.val$providers = providerFactory;
            }

            public void execute(final ConfigurableComponentWithStaticLibrary library) {
                final Names names = library.getNames();
                CreateStaticLibrary createTask = (CreateStaticLibrary)this.val$tasks.create(names.getTaskName("create"), CreateStaticLibrary.class);
                createTask.source((Object)library.getObjects());
                final PlatformToolProvider toolProvider = library.getPlatformToolProvider();
                Provider runtimeFile = this.val$buildDirectory.file(this.val$providers.provider((Callable)new Callable<String>(){

                    @Override
                    public String call() {
                        return toolProvider.getStaticLibraryName("lib/" + names.getDirName() + (String)library.getBaseName().get());
                    }
                }));
                createTask.setOutputFile(runtimeFile);
                createTask.setTargetPlatform(library.getTargetPlatform());
                createTask.setToolChain(library.getToolChain());
                library.getLinkFile().set((Provider)createTask.getBinaryFile());
                library.getCreateTask().set((Object)createTask);
                library.getOutputs().from(new Object[]{library.getLinkFile()});
            }
        });
        ObjectFactory objectFactory = project.getObjects();
        final ConfigurationContainer configurations = project.getConfigurations();
        final Usage linkUsage = (Usage)objectFactory.named(Usage.class, "native-link");
        final Usage runtimeUsage = (Usage)objectFactory.named(Usage.class, "native-runtime");
        project.getDependencies().getAttributesSchema().attribute(CppBinary.LINKAGE_ATTRIBUTE).getDisambiguationRules().add(LinkageSelectionRule.class);
        components.withType(ConfigurableComponentWithLinkUsage.class, (Action)new Action<ConfigurableComponentWithLinkUsage>(){

            public void execute(ConfigurableComponentWithLinkUsage component) {
                Names names = component.getNames();
                Configuration linkElements = (Configuration)configurations.create(names.withSuffix("linkElements"));
                linkElements.extendsFrom(new Configuration[]{component.getImplementationDependencies()});
                linkElements.setCanBeResolved(false);
                linkElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)linkUsage);
                linkElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)component.isDebuggable());
                linkElements.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)component.isOptimized());
                if (component.getLinkage() != null) {
                    linkElements.getAttributes().attribute(CppBinary.LINKAGE_ATTRIBUTE, (Object)component.getLinkage());
                }
                linkElements.getOutgoing().artifact(component.getLinkFile());
                component.getLinkElements().set((Object)linkElements);
            }
        });
        components.withType(ConfigurableComponentWithRuntimeUsage.class, (Action)new Action<ConfigurableComponentWithRuntimeUsage>(){

            public void execute(ConfigurableComponentWithRuntimeUsage component) {
                Names names = component.getNames();
                Configuration runtimeElements = (Configuration)configurations.create(names.withSuffix("runtimeElements"));
                runtimeElements.extendsFrom(new Configuration[]{component.getImplementationDependencies()});
                runtimeElements.setCanBeResolved(false);
                runtimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
                runtimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)component.isDebuggable());
                runtimeElements.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)component.isOptimized());
                if (component.getLinkage() != null) {
                    runtimeElements.getAttributes().attribute(CppBinary.LINKAGE_ATTRIBUTE, (Object)component.getLinkage());
                }
                if (component.hasRuntimeFile()) {
                    runtimeElements.getOutgoing().artifact(component.getRuntimeFile());
                }
                component.getRuntimeElements().set((Object)runtimeElements);
            }
        });
        project.getPluginManager().withPlugin("maven-publish", (Action)new Action<AppliedPlugin>(){

            public void execute(AppliedPlugin appliedPlugin) {
                components.withType(PublicationAwareComponent.class, (Action)new Action<PublicationAwareComponent>(){

                    public void execute(final PublicationAwareComponent component) {
                        project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

                            public void execute(PublishingExtension publishing) {
                                final ComponentWithVariants mainVariant = component.getMainPublication();
                                publishing.getPublications().create("main", MavenPublication.class, (Action)new Action<MavenPublication>(){

                                    public void execute(MavenPublication publication) {
                                        publication.setGroupId(project.getGroup().toString());
                                        publication.setArtifactId((String)component.getBaseName().get());
                                        publication.setVersion(project.getVersion().toString());
                                        publication.from((SoftwareComponent)mainVariant);
                                        ((MavenPublicationInternal)publication).publishWithOriginalFileName();
                                    }
                                });
                                for (final SoftwareComponent child : mainVariant.getVariants()) {
                                    publishing.getPublications().create(child.getName(), MavenPublication.class, (Action)new Action<MavenPublication>(){

                                        public void execute(MavenPublication publication) {
                                            publication.setGroupId(project.getGroup().toString());
                                            publication.setArtifactId((String)component.getBaseName().get() + "_" + GUtil.toWords((CharSequence)child.getName(), (char)'_'));
                                            publication.setVersion(project.getVersion().toString());
                                            publication.from(child);
                                            ((MavenPublicationInternal)publication).publishWithOriginalFileName();
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private StripSymbols stripSymbols(AbstractLinkTask link, Names names, TaskContainer tasks, NativeToolChain toolChain, NativePlatform currentPlatform, Provider<RegularFile> strippedLocation) {
        StripSymbols stripSymbols = (StripSymbols)tasks.create(names.getTaskName("stripSymbols"), StripSymbols.class);
        stripSymbols.getBinaryFile().set((Provider)link.getBinaryFile());
        stripSymbols.getOutputFile().set(strippedLocation);
        stripSymbols.setTargetPlatform(currentPlatform);
        stripSymbols.setToolChain(toolChain);
        return stripSymbols;
    }

    private ExtractSymbols extractSymbols(AbstractLinkTask link, Names names, TaskContainer tasks, NativeToolChain toolChain, NativePlatform currentPlatform, Provider<RegularFile> symbolLocation) {
        ExtractSymbols extractSymbols = (ExtractSymbols)tasks.create(names.getTaskName("extractSymbols"), ExtractSymbols.class);
        extractSymbols.getBinaryFile().set((Provider)link.getBinaryFile());
        extractSymbols.getSymbolFile().set(symbolLocation);
        extractSymbols.setTargetPlatform(currentPlatform);
        extractSymbols.setToolChain(toolChain);
        return extractSymbols;
    }

    static class LinkageSelectionRule
    implements AttributeDisambiguationRule<Linkage> {
        LinkageSelectionRule() {
        }

        public void execute(MultipleCandidatesDetails<Linkage> details) {
            if (details.getCandidateValues().contains(Linkage.SHARED)) {
                details.closestMatch((Object)Linkage.SHARED);
            }
        }
    }
}

