/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.tasks;

import java.io.File;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.ExecSpec;
import org.gradle.util.CollectionUtils;

@Incubating
public class UnexportMainSymbol
extends SourceTask {
    private File mainObjectFile;
    private final DirectoryProperty outputDirectory = this.newOutputDirectory();

    public UnexportMainSymbol() {
        this.outputDirectory.set(this.getTemporaryDir());
    }

    @Internal
    public FileCollection getObjects() {
        return this.outputDirectory.getAsFileTree();
    }

    @OutputDirectory
    public Provider<Directory> getOutputDirectory() {
        return this.outputDirectory;
    }

    @InputFile
    @Optional
    public File getMainObject() {
        if (this.mainObjectFile == null) {
            this.mainObjectFile = this.findMainObject();
        }
        return this.mainObjectFile;
    }

    @TaskAction
    public void unexport() {
        final File mainObjectFile = this.getMainObject();
        if (mainObjectFile != null) {
            final File relocatedMainObject = ((RegularFile)this.outputDirectory.file(mainObjectFile.getName()).get()).getAsFile();
            this.getProject().exec((Action)new Action<ExecSpec>(){

                public void execute(ExecSpec execSpec) {
                    if (OperatingSystem.current().isMacOsX()) {
                        execSpec.executable((Object)"ld");
                        execSpec.args(new Object[]{mainObjectFile});
                        execSpec.args(new Object[]{"-o", relocatedMainObject});
                        execSpec.args(new Object[]{"-r"});
                        execSpec.args(new Object[]{"-unexported_symbol", "_main"});
                    } else if (OperatingSystem.current().isLinux()) {
                        execSpec.executable((Object)"objcopy");
                        execSpec.args(new Object[]{"-L", "main"});
                        execSpec.args(new Object[]{mainObjectFile});
                        execSpec.args(new Object[]{relocatedMainObject});
                    } else {
                        throw new IllegalStateException("Do not know how to hide a main symbol on " + OperatingSystem.current());
                    }
                }
            });
            this.setDidWork(true);
        } else {
            this.setDidWork(this.getProject().delete(new Object[]{this.outputDirectory}));
        }
    }

    private File findMainObject() {
        Set objectFiles = this.getSource().getFiles();
        if (objectFiles.isEmpty()) {
            return null;
        }
        if (objectFiles.size() == 1) {
            return (File)objectFiles.iterator().next();
        }
        return (File)CollectionUtils.findFirst((Iterable)objectFiles, (Spec)new Spec<File>(){

            public boolean isSatisfiedBy(File objectFile) {
                return objectFile.getName().equalsIgnoreCase("main.o");
            }
        });
    }
}

