/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.gradle.api.UncheckedIOException;
import org.gradle.util.GFileUtils;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.VersionControlSystem;
import org.gradle.vcs.VersionRef;
import org.gradle.vcs.internal.DefaultVersionRef;
import org.gradle.vcs.internal.spec.DirectoryRepositorySpec;

public class SimpleVersionControlSystem
implements VersionControlSystem {
    public Set<VersionRef> getAvailableVersions(VersionControlSpec spec) {
        return Sets.newHashSet((Object[])new VersionRef[]{new DefaultVersionRef()});
    }

    public File populate(File versionDir, VersionRef ref, VersionControlSpec spec) {
        File sourceDir = ((DirectoryRepositorySpec)spec).getSourceDir();
        File workingDir = new File(versionDir, sourceDir.getName());
        File checkoutFlag = new File(workingDir, "checkedout");
        try {
            if (!checkoutFlag.exists()) {
                GFileUtils.copyDirectory((File)sourceDir, (File)workingDir);
                checkoutFlag.createNewFile();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        return workingDir;
    }
}

