/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourceLockCoordinationService
implements ResourceLockCoordinationService {
    private final Object lock = new Object();
    private final ThreadLocal<List<ResourceLockState>> currentState = new ThreadLocal<List<ResourceLockState>>(){

        @Override
        protected List<ResourceLockState> initialValue() {
            return Lists.newArrayList();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean withStateLock(Transformer<ResourceLockState.Disposition, ResourceLockState> stateLockAction) {
        while (true) {
            block15: {
                DefaultResourceLockState resourceLockState = new DefaultResourceLockState();
                Object object = this.lock;
                synchronized (object) {
                    Object var7_5;
                    this.currentState.get().add(resourceLockState);
                    ResourceLockState.Disposition disposition = stateLockAction.transform(resourceLockState);
                    switch (disposition) {
                        case RETRY: {
                            resourceLockState.releaseLocks();
                            try {
                                this.lock.wait();
                                break;
                            }
                            catch (InterruptedException e) {
                                throw UncheckedException.throwAsUncheckedException(e);
                            }
                        }
                        case FINISHED: {
                            this.maybeNotifyStateChange(resourceLockState);
                            boolean e = true;
                            var7_5 = null;
                            this.currentState.get().remove(resourceLockState);
                            return e;
                        }
                        case FAILED: {
                            resourceLockState.releaseLocks();
                            boolean e = false;
                            var7_5 = null;
                            this.currentState.get().remove(resourceLockState);
                            return e;
                        }
                        default: {
                            throw new IllegalArgumentException("Unhandled disposition type: " + disposition.name());
                        }
                    }
                    try {
                        var7_5 = null;
                        this.currentState.get().remove(resourceLockState);
                        break block15;
                        catch (Throwable t) {
                            resourceLockState.releaseLocks();
                            throw UncheckedException.throwAsUncheckedException(t);
                        }
                    }
                    catch (Throwable throwable) {
                        var7_5 = null;
                        this.currentState.get().remove(resourceLockState);
                        throw throwable;
                    }
                }
            }
        }
    }

    @Override
    public ResourceLockState getCurrent() {
        if (!this.currentState.get().isEmpty()) {
            int numStates = this.currentState.get().size();
            return this.currentState.get().get(numStates - 1);
        }
        return null;
    }

    private void maybeNotifyStateChange(DefaultResourceLockState resourceLockState) {
        if (resourceLockState.hasUnlockedResources()) {
            this.notifyStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyStateChange() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public static Transformer<ResourceLockState.Disposition, ResourceLockState> lock(Iterable<? extends ResourceLock> resourceLocks) {
        return new AcquireLocks(resourceLocks, true);
    }

    public static Transformer<ResourceLockState.Disposition, ResourceLockState> lock(ResourceLock ... resourceLocks) {
        return DefaultResourceLockCoordinationService.lock(Arrays.asList(resourceLocks));
    }

    public static Transformer<ResourceLockState.Disposition, ResourceLockState> tryLock(Iterable<? extends ResourceLock> resourceLocks) {
        return new AcquireLocks(resourceLocks, false);
    }

    public static Transformer<ResourceLockState.Disposition, ResourceLockState> tryLock(ResourceLock ... resourceLocks) {
        return DefaultResourceLockCoordinationService.tryLock(Arrays.asList(resourceLocks));
    }

    public static Transformer<ResourceLockState.Disposition, ResourceLockState> unlock(Iterable<? extends ResourceLock> resourceLocks) {
        return new ReleaseLocks(resourceLocks);
    }

    public static Transformer<ResourceLockState.Disposition, ResourceLockState> unlock(ResourceLock ... resourceLocks) {
        return DefaultResourceLockCoordinationService.unlock(Arrays.asList(resourceLocks));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReleaseLocks
    implements Transformer<ResourceLockState.Disposition, ResourceLockState> {
        private final Iterable<? extends ResourceLock> resourceLocks;

        ReleaseLocks(Iterable<? extends ResourceLock> resourceLocks) {
            this.resourceLocks = resourceLocks;
        }

        @Override
        public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
            for (ResourceLock resourceLock : this.resourceLocks) {
                resourceLock.unlock();
            }
            return ResourceLockState.Disposition.FINISHED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AcquireLocks
    implements Transformer<ResourceLockState.Disposition, ResourceLockState> {
        private final Iterable<? extends ResourceLock> resourceLocks;
        private final boolean blocking;

        AcquireLocks(Iterable<? extends ResourceLock> resourceLocks, boolean blocking) {
            this.resourceLocks = resourceLocks;
            this.blocking = blocking;
        }

        @Override
        public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
            for (ResourceLock resourceLock : this.resourceLocks) {
                if (resourceLock.tryLock()) continue;
                return this.blocking ? ResourceLockState.Disposition.RETRY : ResourceLockState.Disposition.FAILED;
            }
            return ResourceLockState.Disposition.FINISHED;
        }
    }

    private static class DefaultResourceLockState
    implements ResourceLockState {
        private Set<ResourceLock> lockedResources;
        private Set<ResourceLock> unlockedResources;
        boolean rollback;

        private DefaultResourceLockState() {
        }

        public void registerLocked(ResourceLock resourceLock) {
            if (!(this.rollback || this.unlockedResources != null && this.unlockedResources.remove(resourceLock))) {
                if (this.lockedResources == null) {
                    this.lockedResources = Sets.newHashSet();
                }
                this.lockedResources.add(resourceLock);
            }
        }

        public void registerUnlocked(ResourceLock resourceLock) {
            if (!(this.rollback || this.lockedResources != null && this.lockedResources.remove(resourceLock))) {
                if (this.unlockedResources == null) {
                    this.unlockedResources = Sets.newHashSet();
                }
                this.unlockedResources.add(resourceLock);
            }
        }

        boolean hasUnlockedResources() {
            return this.unlockedResources != null && !this.unlockedResources.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseLocks() {
            if (this.lockedResources != null) {
                this.rollback = true;
                try {
                    for (ResourceLock resourceLock : this.lockedResources) {
                        resourceLock.unlock();
                    }
                    Object var4_3 = null;
                    this.rollback = false;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.rollback = false;
                    throw throwable;
                }
            }
        }
    }
}

