/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javajs.util.Lst;
import org.jmol.api.JmolParallelProcessor;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptFunction;
import org.jmol.script.ScriptProcess;
import org.jmol.script.ScriptProcessRunnable;
import org.jmol.shape.MeshCollection;
import org.jmol.shape.Shape;
import org.jmol.util.Logger;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.Viewer;

public class ScriptParallelProcessor
extends ScriptFunction
implements JmolParallelProcessor {
    Viewer vwr;
    public volatile int counter = 0;
    public volatile Error error = null;
    Object lock = new Object();
    private Lst<ScriptProcess> processes = new Lst();

    @Override
    public Object getExecutor() {
        return Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runAllProcesses(Viewer vwr) {
        if (this.processes.size() == 0) {
            return;
        }
        this.vwr = vwr;
        boolean inParallel = !vwr.isParallel() && vwr.setParallel(true);
        Lst<ShapeManager> vShapeManagers = new Lst<ShapeManager>();
        this.error = null;
        this.counter = 0;
        if (Logger.debugging) {
            Logger.debug("running " + this.processes.size() + " processes on " + Viewer.nProcessors + " processesors inParallel=" + inParallel);
        }
        this.counter = this.processes.size();
        int i = this.processes.size();
        while (--i >= 0) {
            ShapeManager sm = null;
            if (inParallel) {
                sm = new ShapeManager(vwr);
                sm.setParallel();
                vShapeManagers.addLast(sm);
            }
            this.runProcess(this.processes.removeItemAt(0), sm);
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.counter > 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.error == null) continue;
                throw this.error;
            }
        }
        this.mergeResults(vShapeManagers);
        vwr.setParallel(false);
    }

    void mergeResults(Lst<ShapeManager> vShapeManagers) {
        try {
            for (int i = 0; i < vShapeManagers.size(); ++i) {
                this.mergeShapes((ShapeManager)vShapeManagers.get(i));
            }
        }
        catch (Error e) {
            throw e;
        }
        finally {
            this.counter = -1;
            vShapeManagers = null;
        }
    }

    private void mergeShapes(ShapeManager shapeManager) {
        Shape[] newShapes = shapeManager.shapes;
        if (newShapes == null) {
            return;
        }
        if (this.vwr.shm.shapes == null) {
            this.vwr.shm.shapes = newShapes;
        } else {
            for (int i = 0; i < newShapes.length; ++i) {
                if (newShapes[i] == null || !(newShapes[i] instanceof MeshCollection)) continue;
                if (this.vwr.shm.shapes[i] == null) {
                    this.vwr.shm.loadShape(i);
                }
                ((MeshCollection)this.vwr.shm.shapes[i]).merge((MeshCollection)newShapes[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearShapeManager(Error er) {
        ScriptParallelProcessor scriptParallelProcessor = this;
        synchronized (scriptParallelProcessor) {
            this.error = er;
            this.notifyAll();
        }
    }

    @Override
    public void addProcess(String name, ScriptContext context) {
        this.processes.addLast(new ScriptProcess(name, context));
    }

    private void runProcess(ScriptProcess process, ShapeManager shapeManager) {
        Executor exec;
        ScriptProcessRunnable r = new ScriptProcessRunnable(this, process, this.lock, shapeManager);
        Executor executor = exec = shapeManager == null ? null : this.getMyExecutor();
        if (exec != null) {
            exec.execute(r);
        } else {
            r.run();
        }
    }

    void eval(ScriptContext context, ShapeManager shapeManager) {
        this.vwr.evalParallel(context, shapeManager);
    }

    private Executor getMyExecutor() {
        if (this.vwr.executor != null || Viewer.nProcessors < 2) {
            return (Executor)this.vwr.executor;
        }
        try {
            this.vwr.executor = this.getExecutor();
        }
        catch (Exception e) {
            this.vwr.executor = null;
        }
        catch (Error er) {
            this.vwr.executor = null;
        }
        if (this.vwr.executor == null) {
            Logger.error("parallel processing is not available");
        }
        return (Executor)this.vwr.executor;
    }
}

