/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchMode;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class FilterMatcher {
    private final List<FilterInfo> hiddenFilters = new ArrayList<FilterInfo>();
    private final List<FilterInfo> disabledFilters = new ArrayList<FilterInfo>();

    public void update(Collection<Filter> filters) throws SearchParseError {
        this.reset();
        for (Filter filter : filters) {
            this.add(filter);
        }
    }

    public void reset() {
        this.hiddenFilters.clear();
        this.disabledFilters.clear();
    }

    public void add(Filter filter) throws SearchParseError {
        if (!filter.enable) {
            return;
        }
        FilterInfo fi = new FilterInfo(filter);
        if (fi.isDelete) {
            if (filter.hiding) {
                this.hiddenFilters.add(fi);
            } else {
                this.disabledFilters.add(fi);
                this.hiddenFilters.add(fi);
            }
        } else {
            if (filter.mode == SearchMode.replace && filter.hiding) {
                this.hiddenFilters.clear();
                this.disabledFilters.clear();
            }
            this.disabledFilters.add(fi);
            if (filter.hiding) {
                this.hiddenFilters.add(fi);
            }
        }
    }

    private static boolean isFiltered(OsmPrimitive primitive, boolean hidden) {
        return hidden ? primitive.isDisabledAndHidden() : primitive.isDisabled();
    }

    private static boolean isFilterExplicit(OsmPrimitive primitive, boolean hidden) {
        return hidden ? primitive.getHiddenType() : primitive.getDisabledType();
    }

    private static boolean allParentWaysFiltered(OsmPrimitive primitive, boolean hidden) {
        List<OsmPrimitive> refs = primitive.getReferrers();
        boolean isExplicit = false;
        for (OsmPrimitive p : refs) {
            if (!(p instanceof Way)) continue;
            if (!FilterMatcher.isFiltered(p, hidden)) {
                return false;
            }
            isExplicit |= FilterMatcher.isFilterExplicit(p, hidden);
        }
        return isExplicit;
    }

    private static boolean oneParentWayNotFiltered(OsmPrimitive primitive, boolean hidden) {
        List<OsmPrimitive> refs = primitive.getReferrers();
        for (OsmPrimitive p : refs) {
            if (!(p instanceof Way) || FilterMatcher.isFiltered(p, hidden)) continue;
            return true;
        }
        return false;
    }

    private static boolean allParentMultipolygonsFiltered(OsmPrimitive primitive, boolean hidden) {
        boolean isExplicit = false;
        for (Relation r : new SubclassFilteredCollection(primitive.getReferrers(), OsmPrimitive::isMultipolygon)) {
            if (!FilterMatcher.isFiltered(r, hidden)) {
                return false;
            }
            isExplicit |= FilterMatcher.isFilterExplicit(r, hidden);
        }
        return isExplicit;
    }

    private static boolean oneParentMultipolygonNotFiltered(OsmPrimitive primitive, boolean hidden) {
        for (Relation r : new SubclassFilteredCollection(primitive.getReferrers(), OsmPrimitive::isMultipolygon)) {
            if (FilterMatcher.isFiltered(r, hidden)) continue;
            return true;
        }
        return false;
    }

    private static FilterType test(List<FilterInfo> filters, OsmPrimitive primitive, boolean hidden) {
        if (primitive.isIncomplete() || primitive.isPreserved()) {
            return FilterType.NOT_FILTERED;
        }
        boolean filtered = false;
        boolean explicitlyFiltered = false;
        for (FilterInfo fi : filters) {
            if (fi.isDelete) {
                if (!filtered || !fi.match.match(primitive)) continue;
                filtered = false;
                continue;
            }
            if (filtered && (explicitlyFiltered || fi.isInverted) || !fi.match.match(primitive)) continue;
            filtered = true;
            if (fi.isInverted) continue;
            explicitlyFiltered = true;
        }
        if (primitive instanceof Node) {
            if (filtered) {
                if (explicitlyFiltered) {
                    return FilterType.PASSIV;
                }
                if (FilterMatcher.oneParentWayNotFiltered(primitive, hidden)) {
                    return FilterType.NOT_FILTERED;
                }
                return FilterType.PASSIV;
            }
            if (!primitive.isTagged() && FilterMatcher.allParentWaysFiltered(primitive, hidden)) {
                return FilterType.PASSIV;
            }
            return FilterType.NOT_FILTERED;
        }
        if (primitive instanceof Way) {
            if (filtered) {
                if (explicitlyFiltered) {
                    return FilterType.EXPLICIT;
                }
                if (FilterMatcher.oneParentMultipolygonNotFiltered(primitive, hidden)) {
                    return FilterType.NOT_FILTERED;
                }
                return FilterType.PASSIV;
            }
            if (!primitive.isTagged() && FilterMatcher.allParentMultipolygonsFiltered(primitive, hidden)) {
                return FilterType.EXPLICIT;
            }
            return FilterType.NOT_FILTERED;
        }
        if (filtered) {
            return explicitlyFiltered ? FilterType.EXPLICIT : FilterType.PASSIV;
        }
        return FilterType.NOT_FILTERED;
    }

    public FilterType isHidden(OsmPrimitive primitive) {
        return FilterMatcher.test(this.hiddenFilters, primitive, true);
    }

    public FilterType isDisabled(OsmPrimitive primitive) {
        return FilterMatcher.test(this.disabledFilters, primitive, false);
    }

    public static FilterMatcher of(Filter ... filters) throws SearchParseError {
        FilterMatcher result = new FilterMatcher();
        for (Filter filter : filters) {
            result.add(filter);
        }
        return result;
    }

    private static class FilterInfo {
        private final SearchCompiler.Match match;
        private final boolean isDelete;
        private final boolean isInverted;

        FilterInfo(Filter filter) throws SearchParseError {
            this.isDelete = filter.mode == SearchMode.remove || filter.mode == SearchMode.in_selection;
            SearchCompiler.Match compiled = SearchCompiler.compile(filter);
            this.match = filter.inverted ? new SearchCompiler.Not(compiled) : compiled;
            this.isInverted = filter.inverted;
        }
    }

    public static enum FilterType {
        NOT_FILTERED,
        EXPLICIT,
        PASSIV;

    }
}

